/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktlint.compat;

import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatAdapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatReporting;
import com.pinterest.ktlint.cli.ruleset.core.api.RuleSetProviderV3;
import com.pinterest.ktlint.rule.engine.api.Code;
import com.pinterest.ktlint.rule.engine.api.EditorConfigDefaults;
import com.pinterest.ktlint.rule.engine.api.EditorConfigOverride;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleEngine;
import com.pinterest.ktlint.rule.engine.api.LintError;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.RuleId;
import com.pinterest.ktlint.rule.engine.core.api.RuleProvider;
import com.pinterest.ktlint.rule.engine.core.api.RuleProviderKt;
import com.pinterest.ktlint.rule.engine.core.api.RuleSetId;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EndOfLinePropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.InsertFinalNewLineEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecution;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecutionEditorConfigPropertyKt;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KtLintCompat1Dot0Dot0Adapter
implements KtLintCompatAdapter {
    private static final Logger logger = LoggerFactory.getLogger(KtLintCompat1Dot0Dot0Adapter.class);
    private static final List<EditorConfigProperty<?>> DEFAULT_EDITOR_CONFIG_PROPERTIES = List.of(CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY(), EndOfLinePropertyKt.getEND_OF_LINE_PROPERTY(), IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY(), InsertFinalNewLineEditorConfigPropertyKt.getINSERT_FINAL_NEWLINE_PROPERTY(), MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY(), RuleExecutionEditorConfigPropertyKt.getEXPERIMENTAL_RULES_EXECUTION_PROPERTY());

    @Override
    public String format(String unix, Path path, Path editorConfigPath, Map<String, Object> editorConfigOverrideMap) {
        FormatterCallback formatterCallback = new FormatterCallback();
        Set allRuleProviders = ServiceLoader.load(RuleSetProviderV3.class, RuleSetProviderV3.class.getClassLoader()).stream().flatMap(loader -> ((RuleSetProviderV3)loader.get()).getRuleProviders().stream()).collect(Collectors.toUnmodifiableSet());
        EditorConfigDefaults editorConfig = EditorConfigDefaults.Companion.load(editorConfigPath, RuleProviderKt.propertyTypes(allRuleProviders));
        EditorConfigOverride editorConfigOverride = editorConfigOverrideMap.isEmpty() ? EditorConfigOverride.Companion.getEMPTY_EDITOR_CONFIG_OVERRIDE() : KtLintCompat1Dot0Dot0Adapter.createEditorConfigOverride(editorConfig, allRuleProviders.stream().map(RuleProvider::createNewRuleInstance).collect(Collectors.toList()), editorConfigOverrideMap);
        Code code = Code.Companion.fromPath(path);
        KtLintCompatAdapter.setCodeContent(code, unix);
        return new KtLintRuleEngine(allRuleProviders, editorConfig, editorConfigOverride, false, path.getFileSystem()).format(code, (Function2)formatterCallback);
    }

    private static EditorConfigOverride createEditorConfigOverride(EditorConfigDefaults editorConfig, List<Rule> rules, Map<String, Object> editorConfigOverrideMap) {
        Stream ruleProperties = rules.stream().flatMap(rule -> rule.getUsesEditorConfigProperties().stream());
        Map<String, EditorConfigProperty> supportedProperties = Stream.concat(ruleProperties, DEFAULT_EDITOR_CONFIG_PROPERTIES.stream()).distinct().collect(Collectors.toMap(EditorConfigProperty::getName, property -> property));
        boolean isCodeStyleDefinedInEditorConfig = editorConfig.getValue().getSections().stream().anyMatch(section -> section.getProperties().containsKey("ktlint_code_style"));
        if (!isCodeStyleDefinedInEditorConfig && !editorConfigOverrideMap.containsKey("ktlint_code_style")) {
            editorConfigOverrideMap.put("ktlint_code_style", "intellij_idea");
        }
        Pair[] properties = (Pair[])editorConfigOverrideMap.entrySet().stream().map(entry -> {
            EditorConfigProperty property = (EditorConfigProperty)supportedProperties.get(entry.getKey());
            if (property == null && ((String)entry.getKey()).startsWith("ktlint_")) {
                String[] parts = ((String)entry.getKey()).substring(7).split("_", 2);
                if (parts.length == 1) {
                    RuleSetId id = new RuleSetId(parts[0]);
                    property = RuleExecutionEditorConfigPropertyKt.createRuleSetExecutionEditorConfigProperty((RuleSetId)id, (RuleExecution)RuleExecution.enabled);
                } else {
                    RuleId id = new RuleId(parts[0] + ":" + parts[1]);
                    property = RuleExecutionEditorConfigPropertyKt.createRuleExecutionEditorConfigProperty((RuleId)id, (RuleExecution)RuleExecution.enabled);
                }
            }
            if (property == null) {
                return null;
            }
            return new Pair((Object)property, entry.getValue());
        }).filter(Objects::nonNull).toArray(Pair[]::new);
        return EditorConfigOverride.Companion.from(properties);
    }

    static class FormatterCallback
    implements Function2<LintError, Boolean, Unit> {
        FormatterCallback() {
        }

        public Unit invoke(LintError lint, Boolean corrected) {
            if (!corrected.booleanValue()) {
                KtLintCompatReporting.report(lint.getLine(), lint.getCol(), lint.getRuleId().getValue(), lint.getDetail());
            }
            return Unit.INSTANCE;
        }
    }
}

