/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.Formatter;
import java.util.AbstractList;
import javax.annotation.Nullable;

class ValuePerStep<T>
extends AbstractList<T> {
    private final int size;
    @Nullable
    private T value;
    private int valueIdx;
    @Nullable
    private Object[] multipleValues = null;

    ValuePerStep(Formatter formatter) {
        this.size = formatter.getSteps().size();
    }

    @Override
    @Nullable
    public T set(int index, T newValue) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (this.value == null) {
            this.valueIdx = index;
            this.value = newValue;
            return null;
        }
        if (this.multipleValues != null) {
            Object previousValue = this.multipleValues[index];
            this.multipleValues[index] = newValue;
            return (T)previousValue;
        }
        if (index == this.valueIdx) {
            T previousValue = this.value;
            this.value = newValue;
            return previousValue;
        }
        this.multipleValues = new Object[this.size];
        this.multipleValues[this.valueIdx] = this.value;
        this.multipleValues[index] = newValue;
        return null;
    }

    @Override
    public T get(int index) {
        if (this.multipleValues != null) {
            return (T)this.multipleValues[index];
        }
        if (this.valueIdx == index) {
            return this.value;
        }
        return null;
    }

    public int indexOfFirstValue() {
        if (this.multipleValues != null) {
            for (int i = 0; i < this.multipleValues.length; ++i) {
                if (this.multipleValues[i] == null) continue;
                return i;
            }
            return -1;
        }
        if (this.value != null) {
            return this.valueIdx;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }
}

