/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class TestEnvVars {
    private final Map<String, String> envVars;
    private static TestEnvVars INSTANCE;

    private TestEnvVars(Map<String, String> envVars) {
        this.envVars = Map.copyOf(envVars);
    }

    public static synchronized TestEnvVars read() {
        if (INSTANCE == null) {
            INSTANCE = new TestEnvVars(TestEnvVars.readTestEnvVars());
        }
        return INSTANCE;
    }

    private static Map<String, String> readTestEnvVars() {
        HashMap<String, String> envVars = new HashMap<String, String>();
        Optional<Path> resolvedTestenvProps = TestEnvVars.candidateTestEnvLocations().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
        resolvedTestenvProps.ifPresent(testenvProps -> {
            try (BufferedReader reader = Files.newBufferedReader(testenvProps);){
                Properties properties = new Properties();
                properties.load(reader);
                for (String name : properties.stringPropertyNames()) {
                    envVars.put(name, properties.getProperty(name));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read test environment variables", e);
            }
        });
        return envVars;
    }

    private static Stream<Path> candidateTestEnvLocations() {
        Stream.Builder<Path> builder = Stream.builder();
        if (System.getProperty("testenv.properties.path") != null) {
            builder.add(Path.of(System.getProperty("testenv.properties.path"), new String[0]));
        }
        if (System.getProperty("spotlessProjectDir") != null) {
            builder.add(Path.of(System.getProperty("spotlessProjectDir"), "testenv.properties"));
        }
        builder.add(Path.of(System.getProperty("user.dir"), "testenv.properties"));
        builder.add(Objects.requireNonNull(Path.of(System.getProperty("user.dir"), new String[0]).getParent()).resolve("testenv.properties"));
        return builder.build();
    }

    @Nullable
    public String get(String key) {
        return this.envVars.get(key);
    }

    public String getOrDefault(String key, String defaultValue) {
        return this.envVars.getOrDefault(key, defaultValue);
    }

    public String getOrThrow(String key) {
        String value = this.envVars.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Environment variable " + key + " not found");
        }
        return value;
    }

    public boolean hasKey(String key) {
        return this.envVars.containsKey(key);
    }
}

