/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.BadSemver;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;
import javax.annotation.Nullable;

public class DiktatStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JarState.Promised jarState;
    private final String versionDiktat;
    private final boolean isScript;
    @Nullable
    private final FileSignature.Promised config;
    private static final String MIN_SUPPORTED_VERSION = "1.2.1";
    private static final String PACKAGE_RELOCATED_VERSION = "2.0.0";
    private static final String DEFAULT_VERSION = "2.0.0";
    private static final String NAME = "diktat";
    private static final String MAVEN_COORDINATE_PRE_2_0_0 = "org.cqfn.diktat:diktat-rules:";
    private static final String MAVEN_COORDINATE = "com.saveourtool.diktat:diktat-runner:";

    private DiktatStep(JarState.Promised jarState, String versionDiktat, boolean isScript, @Nullable FileSignature config) {
        this.jarState = jarState;
        this.versionDiktat = versionDiktat;
        this.isScript = isScript;
        this.config = config != null ? config.asPromise() : null;
    }

    public static String defaultVersionDiktat() {
        return "2.0.0";
    }

    public static FormatterStep create(Provisioner provisioner) {
        return DiktatStep.create(DiktatStep.defaultVersionDiktat(), provisioner);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner) {
        return DiktatStep.create(versionDiktat, provisioner, null);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner, @Nullable FileSignature config) {
        return DiktatStep.create(versionDiktat, provisioner, false, config);
    }

    public static FormatterStep create(String versionDiktat, Provisioner provisioner, boolean isScript, @Nullable FileSignature config) {
        if (BadSemver.version(versionDiktat) < BadSemver.version(MIN_SUPPORTED_VERSION)) {
            throw new IllegalStateException("Minimum required Diktat version is 1.2.1, you tried " + versionDiktat + " which is too old");
        }
        Objects.requireNonNull(versionDiktat, "versionDiktat");
        Objects.requireNonNull(provisioner, "provisioner");
        String diktatCoordinate = BadSemver.version(versionDiktat) >= BadSemver.version("2.0.0") ? MAVEN_COORDINATE + versionDiktat : MAVEN_COORDINATE_PRE_2_0_0 + versionDiktat;
        return FormatterStep.create(NAME, new DiktatStep(JarState.promise(() -> JarState.from(diktatCoordinate, provisioner)), versionDiktat, isScript, config), DiktatStep::equalityState, State::createFormat);
    }

    private State equalityState() throws Exception {
        return new State(this.jarState.get(), this.versionDiktat, this.isScript, this.config != null ? this.config.get() : null);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jar;
        final String versionDiktat;
        private final boolean isScript;
        @Nullable
        private final FileSignature config;

        State(JarState jar, String versionDiktat, boolean isScript, @Nullable FileSignature config) {
            this.jar = jar;
            this.versionDiktat = versionDiktat;
            this.isScript = isScript;
            this.config = config;
        }

        FormatterFunc createFormat() throws Exception {
            File configFile = this.config != null ? this.config.getOnlyFile() : null;
            Class<?> formatterFunc = this.jar.getClassLoader().loadClass("com.diffplug.spotless.glue.diktat.DiktatFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class, File.class, Boolean.TYPE);
            return (FormatterFunc.NeedsFile)constructor.newInstance(this.versionDiktat, configFile, this.isScript);
        }
    }
}

