/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.FormatterStepSerializationRoundtrip;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.yaml.SerializeToByteArrayHack;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ConfigurationCacheHackList
implements Serializable {
    private static final long serialVersionUID = 6914178791997323870L;
    private boolean optimizeForEquality;
    private ArrayList<Object> backingList = new ArrayList();

    private boolean shouldWeSerializeToByteArrayFirst() {
        return this.backingList.stream().anyMatch(step -> step instanceof SerializeToByteArrayHack);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        boolean serializeToByteArrayFirst = this.shouldWeSerializeToByteArrayFirst();
        out.writeBoolean(serializeToByteArrayFirst);
        out.writeBoolean(this.optimizeForEquality);
        out.writeInt(this.backingList.size());
        for (Object obj : this.backingList) {
            if (serializeToByteArrayFirst) {
                out.writeObject(LazyForwardingEquality.toBytes((Serializable)obj));
                continue;
            }
            out.writeObject(obj);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean serializeToByteArrayFirst = in.readBoolean();
        this.optimizeForEquality = in.readBoolean();
        this.backingList = new ArrayList();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            if (serializeToByteArrayFirst) {
                this.backingList.add(LazyForwardingEquality.fromBytes((byte[])in.readObject()));
                continue;
            }
            this.backingList.add(in.readObject());
        }
    }

    public static ConfigurationCacheHackList forEquality() {
        return new ConfigurationCacheHackList(true);
    }

    public static ConfigurationCacheHackList forRoundtrip() {
        return new ConfigurationCacheHackList(false);
    }

    private ConfigurationCacheHackList(boolean optimizeForEquality) {
        this.optimizeForEquality = optimizeForEquality;
    }

    public void clear() {
        this.backingList.clear();
    }

    public void addAll(Collection<? extends FormatterStep> c) {
        for (FormatterStep formatterStep : c) {
            if (formatterStep instanceof FormatterStepSerializationRoundtrip) {
                FormatterStepSerializationRoundtrip roundtrip = (FormatterStepSerializationRoundtrip)formatterStep;
                FormatterStepSerializationRoundtrip.HackClone<?, ?> clone = roundtrip.hackClone(this.optimizeForEquality);
                this.backingList.add(clone);
                continue;
            }
            this.backingList.add(formatterStep);
        }
    }

    public List<FormatterStep> getSteps() {
        ArrayList<FormatterStep> result = new ArrayList<FormatterStep>(this.backingList.size());
        for (Object obj : this.backingList) {
            if (obj instanceof FormatterStepSerializationRoundtrip.HackClone) {
                FormatterStepSerializationRoundtrip.HackClone clone = (FormatterStepSerializationRoundtrip.HackClone)obj;
                result.add(clone.rehydrate());
                continue;
            }
            result.add((FormatterStep)obj);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationCacheHackList stepList = (ConfigurationCacheHackList)o;
        return this.optimizeForEquality == stepList.optimizeForEquality && this.backingList.equals(stepList.backingList);
    }

    public int hashCode() {
        return Objects.hash(this.optimizeForEquality, this.backingList);
    }
}

