/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.java;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.P2Mirror;
import com.diffplug.spotless.extra.java.EclipseJdtFormatterStep;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystemSession;

public class Eclipse
implements FormatterStepFactory {
    @Parameter
    private String file;
    @Parameter
    private String version;
    @Parameter
    private List<P2Mirror> p2Mirrors = new ArrayList<P2Mirror>();
    @Parameter
    private Boolean sortMembersDoNotSortFields = true;
    @Parameter
    private Boolean sortMembersEnabled = false;
    @Parameter
    private String sortMembersOrder;
    @Parameter
    private String sortMembersVisibilityOrder;
    @Parameter
    private Boolean sortMembersVisibilityOrderEnabled = false;
    private File cacheDirectory;

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig stepConfig) {
        EclipseJdtFormatterStep.Builder eclipseConfig = EclipseJdtFormatterStep.createBuilder((Provisioner)stepConfig.getProvisioner());
        eclipseConfig.setVersion(this.version == null ? EclipseJdtFormatterStep.defaultVersion() : this.version);
        if (null != this.file) {
            File settingsFile = stepConfig.getFileLocator().locateFile(this.file);
            eclipseConfig.setPreferences(Arrays.asList(settingsFile));
        }
        eclipseConfig.setP2Mirrors(this.p2Mirrors);
        if (null != this.cacheDirectory) {
            eclipseConfig.setCacheDirectory(this.cacheDirectory);
        }
        if (null != this.sortMembersEnabled) {
            eclipseConfig.sortMembersEnabled(this.sortMembersEnabled.booleanValue());
        }
        if (null != this.sortMembersOrder) {
            eclipseConfig.sortMembersOrder(this.sortMembersOrder);
        }
        if (null != this.sortMembersDoNotSortFields) {
            eclipseConfig.sortMembersDoNotSortFields(this.sortMembersDoNotSortFields.booleanValue());
        }
        if (null != this.sortMembersVisibilityOrder) {
            eclipseConfig.sortMembersVisibilityOrder(this.sortMembersVisibilityOrder);
        }
        if (null != this.sortMembersVisibilityOrderEnabled) {
            eclipseConfig.sortMembersVisibilityOrderEnabled(this.sortMembersVisibilityOrderEnabled.booleanValue());
        }
        if (null != this.cacheDirectory) {
            eclipseConfig.setCacheDirectory(this.cacheDirectory);
        }
        return eclipseConfig.build();
    }

    @Override
    public void init(RepositorySystemSession repositorySystemSession) {
        this.cacheDirectory = repositorySystemSession.getLocalRepository().getBasedir();
    }
}

