/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.client;

import com.edb.aq.UDTType;
import com.edb.aq.operations.UDTTypeReflection;
import com.edb.jms.client.EDBJmsMessageConsumer;
import com.edb.jms.client.EDBJmsMessageProducer;
import com.edb.jms.client.EDBJmsQueue;
import com.edb.jms.client.EDBQueueTable;
import com.edb.jms.message.EDBTextMessageImpl;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class EDBJmsSession
implements Session {
    private Connection _connection;
    private boolean _transacted;
    private int _acknowledgeMode;

    public Connection getConnection() {
        return this._connection;
    }

    public EDBJmsSession(Connection connection, boolean transacted, int acknowledgeMode) {
        this._connection = connection;
        this._transacted = transacted;
        this._acknowledgeMode = acknowledgeMode;
    }

    protected void sendMessage(Message message, Destination dest) throws JMSException {
        String queueName = ((EDBJmsQueue)dest).getQueueName();
        this.enqueueMessage((UDTType)message, queueName);
    }

    private boolean enqueueMessage(UDTType udtType, String queueName) {
        try (CallableStatement callStmt = this._connection.prepareCall("{call DBMS_AQ.ENQUEUE(?,?,?,?,?)}");){
            callStmt.setString(1, queueName);
            Struct enqueueOptions = this._connection.createStruct("dbms_aq.enqueue_options_t", new Object[]{0, null, null, null, 0});
            callStmt.setObject(2, (Object)enqueueOptions);
            Struct messageProperties = this._connection.createStruct("dbms_aq.message_properties_t", new Object[]{1, 0, null, null, null, null, null, null, null, null, null, 0});
            callStmt.setObject(3, (Object)messageProperties);
            Object[] paramObjects = UDTTypeReflection.getParamValues(udtType);
            Struct mytype = this._connection.createStruct(udtType.getName(), paramObjects);
            callStmt.setObject(4, (Object)mytype);
            callStmt.registerOutParameter(5, -2);
            boolean result = callStmt.execute();
            System.out.println("Message Queued Successfully.");
        }
        catch (SQLException ex) {
            Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    private Message dequeueMessage(String queueName, String typeName, int dequeueMode) throws JMSException {
        TextMessage message = null;
        try (CallableStatement callStmt = this._connection.prepareCall("{call DBMS_AQ.DEQUEUE(?,?,?,?::" + typeName + ",?)}");){
            callStmt.setString(1, queueName);
            Struct dequeueOptions = this._connection.createStruct("dbms_aq.dequeue_options_t", new Object[]{null, dequeueMode, 1, 0, 1, null, null, null, null, 0});
            callStmt.setObject(2, (Object)dequeueOptions);
            callStmt.registerOutParameter(3, 2002, "dbms_aq.message_properties_t");
            callStmt.registerOutParameter(4, 2002, typeName);
            callStmt.registerOutParameter(5, -2);
            callStmt.execute();
            Struct str = (Struct)callStmt.getObject(4);
            Object[] obj = str.getAttributes();
            StringBuilder strBuff = new StringBuilder();
            for (int i = 0; i < obj.length; ++i) {
                strBuff.append(obj[i]).append(" ");
            }
            String msgText = strBuff.substring(0, strBuff.length() - 1);
            message = this.createTextMessage(msgText);
        }
        catch (SQLException ex) {
            Logger.getLogger(Queue.class.getName()).log(Level.SEVERE, null, ex);
        }
        return message;
    }

    public Message receive(Destination dest) throws JMSException {
        EDBJmsQueue queue = (EDBJmsQueue)dest;
        String queueName = queue.getQueueName();
        String typeName = queue.getTypeName();
        int dequeueMode = queue.getDequeue_mode();
        return this.dequeueMessage(queueName, typeName, dequeueMode);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MapMessage createMapMessage() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Message createMessage() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ObjectMessage createObjectMessage(Serializable arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public StreamMessage createStreamMessage() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TextMessage createTextMessage() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        EDBTextMessageImpl txtMsg = new EDBTextMessageImpl();
        txtMsg.setText(text);
        return txtMsg;
    }

    public boolean getTransacted() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getAcknowledgeMode() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void commit() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void rollback() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void recover() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMessageListener(MessageListener arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void run() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new EDBJmsMessageProducer(this, destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return new EDBJmsMessageConsumer(this, 1L, destination, null);
    }

    public MessageConsumer createConsumer(Destination arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createConsumer(Destination arg0, String arg1, boolean arg2) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createSharedConsumer(Topic arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createSharedConsumer(Topic arg0, String arg1, String arg2) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (queueName == null || queueName.length() <= 0) {
            throw new JMSException("Cannot create a queue with null or empty name");
        }
        EDBJmsQueue queue = new EDBJmsQueue(queueName);
        return queue;
    }

    public EDBQueueTable createQueueTable(Connection conn, String queueTableName, String queuePayloadType, String comments) throws JMSException {
        if (queueTableName == null || queueTableName.length() <= 0) {
            throw new JMSException("Cannot create a queue with null or empty name");
        }
        EDBQueueTable queueTable = new EDBQueueTable(conn, queueTableName, queuePayloadType, comments);
        try (CallableStatement callStmt = conn.prepareCall("{call DBMS_AQADM.CREATE_QUEUE_TABLE(?,?,?,?,?,?,?,?,?,?,?,?)}");){
            callStmt.setString(1, queueTableName);
            callStmt.setString(2, queuePayloadType);
            callStmt.setString(3, null);
            callStmt.setString(4, null);
            callStmt.setBoolean(5, false);
            callStmt.setInt(6, 0);
            callStmt.setString(7, comments);
            callStmt.setBoolean(8, true);
            callStmt.setInt(9, 0);
            callStmt.setInt(10, 0);
            callStmt.setString(11, null);
            callStmt.setBoolean(12, false);
            callStmt.execute();
            System.out.println("Queue table created successfully.");
        }
        catch (SQLException ex) {
            System.out.println(ex.getMessage());
        }
        return queueTable;
    }

    public Topic createTopic(String arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TopicSubscriber createDurableSubscriber(Topic arg0, String arg1, String arg2, boolean arg3) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createDurableConsumer(Topic arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createDurableConsumer(Topic arg0, String arg1, String arg2, boolean arg3) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createSharedDurableConsumer(Topic arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public MessageConsumer createSharedDurableConsumer(Topic arg0, String arg1, String arg2) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public QueueBrowser createBrowser(Queue arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public QueueBrowser createBrowser(Queue arg0, String arg1) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unsubscribe(String arg0) throws JMSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

