/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerFacade {
    private final Class<?> _forClass;
    private WrappedLogger _logger;

    private LoggerFacade(Class<?> forClass) {
        this._forClass = forClass;
    }

    public static LoggerFacade getLogger(Class<?> forClass) {
        return new LoggerFacade(forClass);
    }

    public void warn(String msg) {
        this._warn(msg);
    }

    public void warn(String msg, Object arg) {
        this._warn(String.format(msg, arg));
    }

    public void warn(String msg, Object arg, Object arg2) {
        this._warn(String.format(msg, arg, arg2));
    }

    private synchronized void _warn(String message) {
        if (this._logger == null) {
            this._logger = WrappedLogger.logger(this._forClass);
        }
        this._logger.warn(message);
    }

    private static class WrappedLogger {
        private final Logger _logger;

        private WrappedLogger(Logger l) {
            this._logger = l;
        }

        public static WrappedLogger logger(Class<?> forClass) {
            try {
                return new WrappedLogger(LoggerFactory.getLogger(forClass));
            }
            catch (Throwable t) {
                return new WrappedLogger(null);
            }
        }

        public void warn(String message) {
            if (this._logger != null) {
                this._logger.warn(message);
            } else {
                System.err.println("WARN: " + message);
            }
        }
    }
}

