/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.util.Collections;
import java.util.List;
import me.chanjar.weixin.channel.api.WxChannelCategoryService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.audit.AuditApplyResponse;
import me.chanjar.weixin.channel.bean.audit.AuditResponse;
import me.chanjar.weixin.channel.bean.audit.CategoryAuditInfo;
import me.chanjar.weixin.channel.bean.audit.CategoryAuditRequest;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.category.CategoryDetailResult;
import me.chanjar.weixin.channel.bean.category.CategoryQualificationResponse;
import me.chanjar.weixin.channel.bean.category.PassCategoryResponse;
import me.chanjar.weixin.channel.bean.category.ShopCategory;
import me.chanjar.weixin.channel.bean.category.ShopCategoryResponse;
import me.chanjar.weixin.channel.util.JsonUtils;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelCategoryServiceImpl
implements WxChannelCategoryService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelCategoryServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxChannelCategoryServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public CategoryQualificationResponse listAllCategory() throws WxErrorException {
        String resJson = (String)this.shopService.executeWithoutLog(SimpleGetRequestExecutor.create(this.shopService), "https://api.weixin.qq.com/channels/ec/category/all", null);
        return ResponseUtils.decode(resJson, CategoryQualificationResponse.class);
    }

    @Override
    public List<ShopCategory> listAvailableCategory(String parentId) throws WxErrorException {
        Long pid = null;
        try {
            pid = Long.parseLong(parentId);
        }
        catch (Throwable e) {
            log.error("parentId\u5fc5\u987b\u4e3a\u6570\u5b57, {}", (Object)parentId, (Object)e);
            return Collections.emptyList();
        }
        String reqJson = "{\"f_cat_id\": " + pid + "}";
        String resJson = (String)this.shopService.executeWithoutLog(SimplePostRequestExecutor.create(this.shopService), "https://api.weixin.qq.com/channels/ec/category/availablesoncategories/get", reqJson);
        ShopCategoryResponse response = ResponseUtils.decode(resJson, ShopCategoryResponse.class);
        return response.getCategories();
    }

    @Override
    public ShopCategoryResponse listAvailableCategories(String fCatId) throws WxErrorException {
        String reqJson = "{\"f_cat_id\": " + fCatId + "}";
        String resJson = (String)this.shopService.executeWithoutLog(SimplePostRequestExecutor.create(this.shopService), "https://api.weixin.qq.com/channels/ec/category/availablesoncategories/get", reqJson);
        return ResponseUtils.decode(resJson, ShopCategoryResponse.class);
    }

    @Override
    public CategoryDetailResult getCategoryDetail(String id) throws WxErrorException {
        Long catId = null;
        try {
            catId = Long.parseLong(id);
        }
        catch (Throwable e) {
            log.error("id\u5fc5\u987b\u4e3a\u6570\u5b57, {}", (Object)id, (Object)e);
            return ResponseUtils.internalError(CategoryDetailResult.class);
        }
        String reqJson = "{\"cat_id\": " + catId + "}";
        String resJson = (String)this.shopService.executeWithoutLog(SimplePostRequestExecutor.create(this.shopService), "https://api.weixin.qq.com/channels/ec/category/detail", reqJson);
        return ResponseUtils.decode(resJson, CategoryDetailResult.class);
    }

    @Override
    public AuditApplyResponse addCategory(String level1, String level2, String level3, List<String> certificate) throws WxErrorException {
        String reqJson = null;
        try {
            Long l1 = Long.parseLong(level1);
            Long l2 = Long.parseLong(level2);
            Long l3 = Long.parseLong(level3);
            CategoryAuditInfo categoryInfo = new CategoryAuditInfo();
            categoryInfo.setLevel1(l1);
            categoryInfo.setLevel2(l2);
            categoryInfo.setLevel3(l3);
            categoryInfo.setCertificates(certificate);
            reqJson = JsonUtils.encode(new CategoryAuditRequest(categoryInfo));
        }
        catch (Throwable e) {
            log.error("\u5fae\u4fe1\u8bf7\u6c42\u5f02\u5e38", e);
        }
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/category/add", reqJson);
        return ResponseUtils.decode(resJson, AuditApplyResponse.class);
    }

    @Override
    public AuditApplyResponse addCategory(CategoryAuditInfo info) throws WxErrorException {
        String reqJson = JsonUtils.encode(new CategoryAuditRequest(info));
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/category/add", reqJson);
        return ResponseUtils.decode(resJson, AuditApplyResponse.class);
    }

    @Override
    public WxChannelBaseResponse cancelCategoryAudit(String auditId) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/category/audit/cancel", "{\"audit_id\": \"" + auditId + "\"}");
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public AuditResponse getAudit(String auditId) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/category/audit/get", "{\"audit_id\": \"" + auditId + "\"}");
        return ResponseUtils.decode(resJson, AuditResponse.class);
    }

    @Override
    public PassCategoryResponse listPassCategory() throws WxErrorException {
        String resJson = this.shopService.get("https://api.weixin.qq.com/channels/ec/category/list/get", null);
        return ResponseUtils.decode(resJson, PassCategoryResponse.class);
    }
}

