/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxChannelCompassShopService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.compass.CompassFinderBaseParam;
import me.chanjar.weixin.channel.bean.compass.shop.CompassFinderIdParam;
import me.chanjar.weixin.channel.bean.compass.shop.FinderAuthListResponse;
import me.chanjar.weixin.channel.bean.compass.shop.FinderListResponse;
import me.chanjar.weixin.channel.bean.compass.shop.FinderOverallResponse;
import me.chanjar.weixin.channel.bean.compass.shop.FinderProductListResponse;
import me.chanjar.weixin.channel.bean.compass.shop.FinderProductOverallResponse;
import me.chanjar.weixin.channel.bean.compass.shop.ShopLiveListResponse;
import me.chanjar.weixin.channel.bean.compass.shop.ShopOverallResponse;
import me.chanjar.weixin.channel.bean.compass.shop.ShopProductDataParam;
import me.chanjar.weixin.channel.bean.compass.shop.ShopProductDataResponse;
import me.chanjar.weixin.channel.bean.compass.shop.ShopProductListResponse;
import me.chanjar.weixin.channel.bean.compass.shop.ShopSaleProfileDataParam;
import me.chanjar.weixin.channel.bean.compass.shop.ShopSaleProfileDataResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelCompassShopServiceImpl
implements WxChannelCompassShopService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelCompassShopServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxChannelCompassShopServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public ShopOverallResponse getShopOverall(String ds) throws WxErrorException {
        CompassFinderBaseParam param = new CompassFinderBaseParam(ds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/overall/get", param);
        return ResponseUtils.decode(resJson, ShopOverallResponse.class);
    }

    @Override
    public FinderAuthListResponse getFinderAuthorizationList() throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/finder/authorization/list/get", "{}");
        return ResponseUtils.decode(resJson, FinderAuthListResponse.class);
    }

    @Override
    public FinderListResponse getFinderList(String ds) throws WxErrorException {
        CompassFinderBaseParam param = new CompassFinderBaseParam(ds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/finder/list/get", param);
        return ResponseUtils.decode(resJson, FinderListResponse.class);
    }

    @Override
    public FinderOverallResponse getFinderOverall(String ds) throws WxErrorException {
        CompassFinderBaseParam param = new CompassFinderBaseParam(ds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/finder/overall/get", param);
        return ResponseUtils.decode(resJson, FinderOverallResponse.class);
    }

    @Override
    public FinderProductListResponse getFinderProductList(String ds, String finderId) throws WxErrorException {
        CompassFinderIdParam param = new CompassFinderIdParam(ds, finderId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/finder/product/list/get", param);
        return ResponseUtils.decode(resJson, FinderProductListResponse.class);
    }

    @Override
    public FinderProductOverallResponse getFinderProductOverall(String ds, String finderId) throws WxErrorException {
        CompassFinderIdParam param = new CompassFinderIdParam(ds, finderId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/finder/product/overall/get", param);
        return ResponseUtils.decode(resJson, FinderProductOverallResponse.class);
    }

    @Override
    public ShopLiveListResponse getShopLiveList(String ds, String finderId) throws WxErrorException {
        CompassFinderIdParam param = new CompassFinderIdParam(ds, finderId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/live/list/get", param);
        return ResponseUtils.decode(resJson, ShopLiveListResponse.class);
    }

    @Override
    public ShopProductDataResponse getShopProductData(String ds, String productId) throws WxErrorException {
        ShopProductDataParam param = new ShopProductDataParam(ds, productId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/product/data/get", param);
        return ResponseUtils.decode(resJson, ShopProductDataResponse.class);
    }

    @Override
    public ShopProductListResponse getShopProductList(String ds) throws WxErrorException {
        CompassFinderBaseParam param = new CompassFinderBaseParam(ds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/product/list/get", param);
        return ResponseUtils.decode(resJson, ShopProductListResponse.class);
    }

    @Override
    public ShopSaleProfileDataResponse getShopSaleProfileData(String ds, Integer type) throws WxErrorException {
        ShopSaleProfileDataParam param = new ShopSaleProfileDataParam(ds, type);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/compass/shop/sale/profile/data/get", param);
        return ResponseUtils.decode(resJson, ShopSaleProfileDataResponse.class);
    }
}

