/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import me.chanjar.weixin.channel.api.WxChannelLiveDashboardService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.live.dashboard.LiveDataParam;
import me.chanjar.weixin.channel.bean.live.dashboard.LiveDataResponse;
import me.chanjar.weixin.channel.bean.live.dashboard.LiveListParam;
import me.chanjar.weixin.channel.bean.live.dashboard.LiveListResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelLiveDashboardServiceImpl
implements WxChannelLiveDashboardService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelLiveDashboardServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public WxChannelLiveDashboardServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public LiveListResponse getLiveList(Long ds) throws WxErrorException {
        LiveListParam param = new LiveListParam(ds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/livedashboard/getlivelist", param);
        return ResponseUtils.decode(resJson, LiveListResponse.class);
    }

    @Override
    public LiveDataResponse getLiveData(String exportId) throws WxErrorException {
        LiveDataParam param = new LiveDataParam(exportId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/livedashboard/getlivedata", param);
        return this.convertLiveDataResponse(resJson);
    }

    private LiveDataResponse convertLiveDataResponse(String resJson) throws WxErrorException {
        try {
            String[] dataKeyArray;
            ObjectNode rootNode = (ObjectNode)this.objectMapper.readTree(resJson);
            for (String dataKey : dataKeyArray = new String[]{"live_dashboard_data", "live_comparison_index", "live_ec_data_summary", "live_ec_conversion_metric", "live_ec_profile", "live_distribution_channel", "single_live_ec_spu_data_page_v2"}) {
                JsonNode jsonNode = rootNode.get(dataKey);
                if (!ObjectUtils.isNotEmpty((Object)jsonNode)) continue;
                JsonNode dataJsonNode = this.objectMapper.readTree(jsonNode.asText());
                rootNode.set(dataKey, dataJsonNode);
            }
            String json = this.objectMapper.writeValueAsString((Object)rootNode);
            return ResponseUtils.decode(json, LiveDataResponse.class);
        }
        catch (JsonProcessingException e) {
            throw new WxErrorException((Throwable)e);
        }
    }
}

