/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.util.List;
import me.chanjar.weixin.channel.api.WxChannelOrderService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.AddressInfo;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.delivery.DeliveryCompanyResponse;
import me.chanjar.weixin.channel.bean.delivery.DeliveryInfo;
import me.chanjar.weixin.channel.bean.delivery.DeliverySendParam;
import me.chanjar.weixin.channel.bean.delivery.FreshInspectParam;
import me.chanjar.weixin.channel.bean.delivery.PackageAuditInfo;
import me.chanjar.weixin.channel.bean.order.ChangeOrderInfo;
import me.chanjar.weixin.channel.bean.order.DecodeSensitiveInfoResponse;
import me.chanjar.weixin.channel.bean.order.DeliveryUpdateParam;
import me.chanjar.weixin.channel.bean.order.OrderAddressParam;
import me.chanjar.weixin.channel.bean.order.OrderIdParam;
import me.chanjar.weixin.channel.bean.order.OrderInfoParam;
import me.chanjar.weixin.channel.bean.order.OrderInfoResponse;
import me.chanjar.weixin.channel.bean.order.OrderListParam;
import me.chanjar.weixin.channel.bean.order.OrderListResponse;
import me.chanjar.weixin.channel.bean.order.OrderPriceParam;
import me.chanjar.weixin.channel.bean.order.OrderRemarkParam;
import me.chanjar.weixin.channel.bean.order.OrderSearchParam;
import me.chanjar.weixin.channel.bean.order.VirtualTelNumberResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelOrderServiceImpl
implements WxChannelOrderService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelOrderServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxChannelOrderServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public OrderInfoResponse getOrder(String orderId) throws WxErrorException {
        OrderInfoParam param = new OrderInfoParam(orderId, null);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/get", param);
        return ResponseUtils.decode(resJson, OrderInfoResponse.class);
    }

    @Override
    public OrderInfoResponse getOrder(String orderId, Boolean encodeSensitiveInfo) throws WxErrorException {
        OrderInfoParam param = new OrderInfoParam(orderId, encodeSensitiveInfo);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/get", param);
        return ResponseUtils.decode(resJson, OrderInfoResponse.class);
    }

    @Override
    public OrderListResponse getOrders(OrderListParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/list/get", param);
        return ResponseUtils.decode(resJson, OrderListResponse.class);
    }

    @Override
    public OrderListResponse searchOrder(OrderSearchParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/search", param);
        return ResponseUtils.decode(resJson, OrderListResponse.class);
    }

    @Override
    public WxChannelBaseResponse updatePrice(String orderId, Integer expressFee, List<ChangeOrderInfo> changeOrderInfos) throws WxErrorException {
        OrderPriceParam param = new OrderPriceParam(orderId, expressFee, changeOrderInfos);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/price/update", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateRemark(String orderId, String merchantNotes) throws WxErrorException {
        OrderRemarkParam param = new OrderRemarkParam(orderId, merchantNotes);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/merchantnotes/update", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateAddress(String orderId, AddressInfo userAddress) throws WxErrorException {
        OrderAddressParam param = new OrderAddressParam(orderId, userAddress);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/address/update", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateDelivery(DeliveryUpdateParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/deliveryinfo/update", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse acceptAddressModify(String orderId) throws WxErrorException {
        OrderIdParam param = new OrderIdParam(orderId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/addressmodify/accept", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse rejectAddressModify(String orderId) throws WxErrorException {
        OrderIdParam param = new OrderIdParam(orderId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/addressmodify/reject", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse closeOrder(String orderId) {
        return ResponseUtils.internalError(WxChannelBaseResponse.class);
    }

    @Override
    public DeliveryCompanyResponse listDeliveryCompany() throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/deliverycompanylist/get", "{}");
        return ResponseUtils.decode(resJson, DeliveryCompanyResponse.class);
    }

    @Override
    public DeliveryCompanyResponse listDeliveryCompany(Boolean ewaybillOnly) throws WxErrorException {
        String reqJson = "{}";
        if (ewaybillOnly != null) {
            reqJson = "{\"ewaybill_only\":" + ewaybillOnly + "}";
        }
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/deliverycompanylist/new/get", reqJson);
        return ResponseUtils.decode(resJson, DeliveryCompanyResponse.class);
    }

    @Override
    public WxChannelBaseResponse deliveryOrder(String orderId, List<DeliveryInfo> deliveryList) throws WxErrorException {
        DeliverySendParam param = new DeliverySendParam(orderId, deliveryList);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/delivery/send", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse uploadFreshInspect(String orderId, List<PackageAuditInfo> items) throws WxErrorException {
        FreshInspectParam param = new FreshInspectParam(orderId, items);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/freshinspect/submit", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public VirtualTelNumberResponse getVirtualTelNumber(String orderId) throws WxErrorException {
        String reqJson = "{\"order_id\":\"" + orderId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/virtualtelnumber/get", reqJson);
        return ResponseUtils.decode(resJson, VirtualTelNumberResponse.class);
    }

    @Override
    public DecodeSensitiveInfoResponse decodeSensitiveInfo(String orderId) throws WxErrorException {
        String reqJson = "{\"order_id\":\"" + orderId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/order/sensitiveinfo/decode", reqJson);
        return ResponseUtils.decode(resJson, DecodeSensitiveInfoResponse.class);
    }
}

