/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.io.IOException;
import java.util.Objects;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.token.StableTokenParam;
import me.chanjar.weixin.channel.config.WxChannelConfig;
import me.chanjar.weixin.channel.util.JsonUtils;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.common.util.http.okhttp.DefaultOkHttpClientBuilder;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelServiceOkHttpImpl
extends BaseWxChannelServiceImpl<OkHttpClient, OkHttpProxyInfo> {
    private static final Logger log = LoggerFactory.getLogger(WxChannelServiceOkHttpImpl.class);
    private OkHttpClient httpClient;
    private OkHttpProxyInfo httpProxy;

    @Override
    public void initHttp() {
        log.debug("WxChannelServiceOkHttpImpl initHttp");
        if (this.config.getHttpProxyHost() != null && this.config.getHttpProxyPort() > 0) {
            this.httpProxy = OkHttpProxyInfo.httpProxy((String)this.config.getHttpProxyHost(), (int)this.config.getHttpProxyPort(), (String)this.config.getHttpProxyUsername(), (String)this.config.getHttpProxyPassword());
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
            clientBuilder.authenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)WxChannelServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxChannelServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                    return response.request().newBuilder().header("Authorization", credential).build();
                }
            });
            this.httpClient = clientBuilder.build();
        } else {
            this.httpClient = DefaultOkHttpClientBuilder.get().build();
        }
    }

    public OkHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.OK_HTTP;
    }

    @Override
    protected String doGetAccessTokenRequest() throws IOException {
        WxChannelConfig config = this.getConfig();
        String url = StringUtils.isNotEmpty((CharSequence)config.getAccessTokenUrl()) ? config.getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)config.getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s".replace("https://api.weixin.qq.com", config.getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s");
        url = String.format(url, config.getAppid(), config.getSecret());
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = this.getRequestHttpClient().newCall(request).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }

    @Override
    protected String doGetStableAccessTokenRequest(boolean forceRefresh) throws IOException {
        WxChannelConfig config = this.getConfig();
        String url = StringUtils.isNotEmpty((CharSequence)config.getAccessTokenUrl()) ? config.getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)config.getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/stable_token".replace("https://api.weixin.qq.com", config.getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/stable_token");
        StableTokenParam requestParam = new StableTokenParam();
        requestParam.setAppId(config.getAppid());
        requestParam.setSecret(config.getSecret());
        requestParam.setGrantType("client_credential");
        requestParam.setForceRefresh(forceRefresh);
        String requestJson = JsonUtils.encode(requestParam);
        assert (requestJson != null);
        RequestBody body = RequestBody.Companion.create(requestJson, MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.getRequestHttpClient().newCall(request).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }
}

