/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import com.google.gson.JsonObject;
import java.util.List;
import me.chanjar.weixin.channel.api.WxChannelSharerService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.sharer.SharerBindResponse;
import me.chanjar.weixin.channel.bean.sharer.SharerInfoResponse;
import me.chanjar.weixin.channel.bean.sharer.SharerListParam;
import me.chanjar.weixin.channel.bean.sharer.SharerOrderParam;
import me.chanjar.weixin.channel.bean.sharer.SharerOrderResponse;
import me.chanjar.weixin.channel.bean.sharer.SharerSearchParam;
import me.chanjar.weixin.channel.bean.sharer.SharerSearchResponse;
import me.chanjar.weixin.channel.bean.sharer.SharerUnbindParam;
import me.chanjar.weixin.channel.bean.sharer.SharerUnbindResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelSharerServiceImpl
implements WxChannelSharerService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelSharerServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxChannelSharerServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public SharerBindResponse bindSharer(String username) throws WxErrorException {
        JsonObject jsonObject = GsonHelper.buildJsonObject((Object[])new Object[]{"username", username});
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/sharer/bind", jsonObject);
        return ResponseUtils.decode(resJson, SharerBindResponse.class);
    }

    @Override
    public SharerSearchResponse searchSharer(String openid, String username) throws WxErrorException {
        SharerSearchParam param = new SharerSearchParam(openid, username);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/sharer/search_sharer", param);
        return ResponseUtils.decode(resJson, SharerSearchResponse.class);
    }

    @Override
    public SharerInfoResponse listSharer(Integer page, Integer pageSize, Integer sharerType) throws WxErrorException {
        SharerListParam param = new SharerListParam(page, pageSize, sharerType);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/sharer/get_sharer_list", param);
        return ResponseUtils.decode(resJson, SharerInfoResponse.class);
    }

    @Override
    public SharerOrderResponse listSharerOrder(SharerOrderParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/sharer/get_sharer_order_list", param);
        return ResponseUtils.decode(resJson, SharerOrderResponse.class);
    }

    @Override
    public SharerUnbindResponse unbindSharer(List<String> openIds) throws WxErrorException {
        SharerUnbindParam param = new SharerUnbindParam(openIds);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/sharer/unbind", param);
        return ResponseUtils.decode(resJson, SharerUnbindResponse.class);
    }
}

