/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxLeagueWindowService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.league.window.AuthInfoResponse;
import me.chanjar.weixin.channel.bean.league.window.AuthStatusResponse;
import me.chanjar.weixin.channel.bean.league.window.ProductSearchParam;
import me.chanjar.weixin.channel.bean.league.window.WindowProductListResponse;
import me.chanjar.weixin.channel.bean.league.window.WindowProductParam;
import me.chanjar.weixin.channel.bean.league.window.WindowProductResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxLeagueWindowServiceImpl
implements WxLeagueWindowService {
    private static final Logger log = LoggerFactory.getLogger(WxLeagueWindowServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxLeagueWindowServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public WxChannelBaseResponse addProduct(String appid, String openfinderid, String productId) throws WxErrorException {
        WindowProductParam param = new WindowProductParam(appid, openfinderid, productId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/window/add", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WindowProductListResponse listProduct(ProductSearchParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/window/getall", param);
        return ResponseUtils.decode(resJson, WindowProductListResponse.class);
    }

    @Override
    public WxChannelBaseResponse removeProduct(String appid, String openfinderid, String productId) throws WxErrorException {
        WindowProductParam param = new WindowProductParam(appid, openfinderid, productId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/window/remove", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WindowProductResponse getProductDetail(String appid, String openfinderid, String productId) throws WxErrorException {
        WindowProductParam param = new WindowProductParam(appid, openfinderid, productId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/window/getdetail", param);
        return ResponseUtils.decode(resJson, WindowProductResponse.class);
    }

    @Override
    public AuthInfoResponse getWindowAuthInfo(String finderId) throws WxErrorException {
        String reqJson = "{\"finder_id\":\"" + finderId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/windowauth/get", reqJson);
        return ResponseUtils.decode(resJson, AuthInfoResponse.class);
    }

    @Override
    public AuthStatusResponse getWindowAuthStatus(String finderId) throws WxErrorException {
        String reqJson = "{\"finder_id\":\"" + finderId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/windowauth/status/get", reqJson);
        return ResponseUtils.decode(resJson, AuthStatusResponse.class);
    }
}

