/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.util;

import java.lang.reflect.InvocationTargetException;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static <T extends WxChannelBaseResponse> T decode(String json, Class<T> valueType) {
        WxChannelBaseResponse t = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)json)) {
                t = (WxChannelBaseResponse)JsonUtils.decode(json, valueType);
            }
        }
        catch (Exception e) {
            log.error("decode", (Throwable)e);
        }
        if (t == null) {
            t = ResponseUtils.internalError(valueType);
        }
        return (T)t;
    }

    public static <T extends WxChannelBaseResponse> T internalError(Class<T> clazz) {
        try {
            WxChannelBaseResponse t = (WxChannelBaseResponse)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            t.setErrCode(-99);
            t.setErrMsg("\u5185\u90e8\u9519\u8bef");
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("internalError", (Throwable)e);
            return null;
        }
    }

    private ResponseUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

