/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.apache.ApacheSimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.hc.HttpComponentsSimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.jodd.JoddHttpSimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpSimpleGetRequestExecutor;
import okhttp3.OkHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.HttpHost;

public abstract class SimpleGetRequestExecutor<H, P>
implements RequestExecutor<String, String> {
    protected RequestHttp<H, P> requestHttp;

    public SimpleGetRequestExecutor(RequestHttp<H, P> requestHttp) {
        this.requestHttp = requestHttp;
    }

    @Override
    public void execute(String uri, String data, ResponseHandler<String> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle((String)this.execute(uri, data, wxType));
    }

    public static RequestExecutor<String, String> create(RequestHttp<?, ?> requestHttp) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new ApacheSimpleGetRequestExecutor(requestHttp);
            }
            case JODD_HTTP: {
                return new JoddHttpSimpleGetRequestExecutor((RequestHttp<HttpConnectionProvider, ProxyInfo>)requestHttp);
            }
            case OK_HTTP: {
                return new OkHttpSimpleGetRequestExecutor((RequestHttp<OkHttpClient, OkHttpProxyInfo>)requestHttp);
            }
            case HTTP_COMPONENTS: {
                return new HttpComponentsSimpleGetRequestExecutor((RequestHttp<CloseableHttpClient, HttpHost>)requestHttp);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684http\u6267\u884c\u5668\u7c7b\u578b\uff1a" + (Object)((Object)requestHttp.getRequestType()));
    }

    protected String handleResponse(WxType wxType, String responseContent) throws WxErrorException {
        WxError error = WxError.fromJson(responseContent, wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }
}

