/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.apache;

import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.InputStreamData;
import me.chanjar.weixin.common.util.http.MediaInputStreamUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApacheMediaInputStreamUploadRequestExecutor
extends MediaInputStreamUploadRequestExecutor<CloseableHttpClient, HttpHost> {
    public ApacheMediaInputStreamUploadRequestExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    @Override
    public WxMediaUploadResult execute(String uri, InputStreamData data, WxType wxType) throws WxErrorException, IOException {
        String responseContent;
        WxError error;
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (data != null) {
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("media", data.getInputStream(), ContentType.DEFAULT_BINARY, data.getFilename()).setMode(HttpMultipartMode.RFC6532).build();
            httpPost.setEntity(entity);
        }
        if ((error = WxError.fromJson(responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost, Utf8ResponseHandler.INSTANCE), wxType)).getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMediaUploadResult.fromJson(responseContent);
    }
}

