/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.hc;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.bean.result.WxMinishopImageUploadCustomizeResult;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.MinishopUploadRequestCustomizeExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.hc.Utf8ResponseHandler;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpComponentsMinishopMediaUploadRequestCustomizeExecutor
extends MinishopUploadRequestCustomizeExecutor<CloseableHttpClient, HttpHost> {
    private static final Logger log = LoggerFactory.getLogger(HttpComponentsMinishopMediaUploadRequestCustomizeExecutor.class);

    public HttpComponentsMinishopMediaUploadRequestCustomizeExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp, String respType, String imgUrl) {
        super(requestHttp, respType, imgUrl);
    }

    @Override
    public WxMinishopImageUploadCustomizeResult execute(String uri, File file, WxType wxType) throws WxErrorException, IOException {
        HttpEntity entity;
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (this.uploadType.equals("0")) {
            if (file == null) {
                throw new WxErrorException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
            }
            entity = MultipartEntityBuilder.create().addBinaryBody("media", file).addTextBody("resp_type", this.respType).addTextBody("upload_type", this.uploadType).setMode(HttpMultipartMode.EXTENDED).build();
            httpPost.setEntity(entity);
        } else {
            entity = MultipartEntityBuilder.create().addTextBody("resp_type", this.respType).addTextBody("upload_type", this.uploadType).addTextBody("img_url", this.imgUrl).setMode(HttpMultipartMode.EXTENDED).build();
            httpPost.setEntity(entity);
        }
        String responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((ClassicHttpRequest)httpPost, Utf8ResponseHandler.INSTANCE);
        WxError error = WxError.fromJson(responseContent, wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        log.info("responseContent: {}", (Object)responseContent);
        return WxMinishopImageUploadCustomizeResult.fromJson(responseContent);
    }
}

