/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpKfService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountAdd;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountAddResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountDel;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountLink;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountLinkResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountListResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfAccountUpd;
import me.chanjar.weixin.cp.bean.kf.WxCpKfCustomerBatchGetResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfGetCorpStatisticRequest;
import me.chanjar.weixin.cp.bean.kf.WxCpKfGetCorpStatisticResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfGetServicerStatisticRequest;
import me.chanjar.weixin.cp.bean.kf.WxCpKfGetServicerStatisticResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfMsgListResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfMsgSendRequest;
import me.chanjar.weixin.cp.bean.kf.WxCpKfMsgSendResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServiceStateResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServiceStateTransResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServiceUpgradeConfigResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServicerListResp;
import me.chanjar.weixin.cp.bean.kf.WxCpKfServicerOpResp;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpKfServiceImpl
implements WxCpKfService {
    private final WxCpService cpService;
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public WxCpKfAccountAddResp addAccount(WxCpKfAccountAdd add) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/add");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)add));
        return WxCpKfAccountAddResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp updAccount(WxCpKfAccountUpd upd) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/update");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)upd));
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpBaseResp delAccount(WxCpKfAccountDel del) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/del");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)del));
        return WxCpBaseResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfAccountListResp listAccount(Integer offset, Integer limit) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/account/list");
        JsonObject json = new JsonObject();
        if (offset != null) {
            json.addProperty("offset", (Number)offset);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfAccountListResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfAccountLinkResp getAccountLink(WxCpKfAccountLink link) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/add_contact_way");
        String responseContent = this.cpService.post(url, WxCpGsonBuilder.create().toJson((Object)link));
        return WxCpKfAccountLinkResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServicerOpResp addServicer(String openKfid, List<String> userIdList) throws WxErrorException {
        return this.servicerOp(openKfid, userIdList, null, "/cgi-bin/kf/servicer/add");
    }

    @Override
    public WxCpKfServicerOpResp addServicer(String openKfId, List<String> userIdList, List<String> departmentIdList) throws WxErrorException {
        this.validateParameters("/cgi-bin/kf/servicer/add", userIdList, departmentIdList);
        return this.servicerOp(openKfId, userIdList, departmentIdList, "/cgi-bin/kf/servicer/add");
    }

    @Override
    public WxCpKfServicerOpResp delServicer(String openKfid, List<String> userIdList) throws WxErrorException {
        return this.servicerOp(openKfid, userIdList, null, "/cgi-bin/kf/servicer/del");
    }

    @Override
    public WxCpKfServicerOpResp delServicer(String openKfid, List<String> userIdList, List<String> departmentIdList) throws WxErrorException {
        this.validateParameters("/cgi-bin/kf/servicer/del", userIdList, departmentIdList);
        return this.servicerOp(openKfid, userIdList, departmentIdList, "/cgi-bin/kf/servicer/del");
    }

    private void validateParameters(String uri, List<String> userIdList, List<String> departmentIdList) {
        if ((userIdList == null || userIdList.isEmpty()) && (departmentIdList == null || departmentIdList.isEmpty())) {
            throw new IllegalArgumentException("userid_list\u548cdepartment_id_list\u81f3\u5c11\u9700\u8981\u586b\u5176\u4e2d\u4e00\u4e2a");
        }
        if ("/cgi-bin/kf/servicer/del".equals(uri)) {
            if (userIdList != null && userIdList.size() > 100) {
                throw new IllegalArgumentException("\u53ef\u586b\u5145\u4e2a\u6570\uff1a0 ~ 100\u3002\u8d85\u8fc7100\u4e2a\u9700\u5206\u6279\u8c03\u7528\u3002");
            }
            if (departmentIdList != null && departmentIdList.size() > 100) {
                throw new IllegalArgumentException("\u53ef\u586b\u5145\u4e2a\u6570\uff1a0 ~ 100\u3002\u8d85\u8fc7100\u4e2a\u9700\u5206\u6279\u8c03\u7528\u3002");
            }
        } else {
            if (userIdList != null && userIdList.size() > 100) {
                throw new IllegalArgumentException("\u53ef\u586b\u5145\u4e2a\u6570\uff1a0 ~ 100\u3002\u8d85\u8fc7100\u4e2a\u9700\u5206\u6279\u8c03\u7528\u3002");
            }
            if (departmentIdList != null && departmentIdList.size() > 20) {
                throw new IllegalArgumentException("\u53ef\u586b\u5145\u4e2a\u6570\uff1a0 ~ 20\u3002");
            }
        }
    }

    private WxCpKfServicerOpResp servicerOp(String openKfid, List<String> userIdList, List<String> departmentIdList, String uri) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl(uri);
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        if (userIdList != null && !userIdList.isEmpty()) {
            JsonArray userIdArray = new JsonArray();
            userIdList.forEach(arg_0 -> ((JsonArray)userIdArray).add(arg_0));
            json.add("userid_list", (JsonElement)userIdArray);
        }
        if (departmentIdList != null && !departmentIdList.isEmpty()) {
            JsonArray departmentIdArray = new JsonArray();
            departmentIdList.forEach(arg_0 -> ((JsonArray)departmentIdArray).add(arg_0));
            json.add("department_id_list", (JsonElement)departmentIdArray);
        }
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfServicerOpResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServicerListResp listServicer(String openKfid) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/servicer/list?open_kfid=" + openKfid);
        String responseContent = this.cpService.get(url, null);
        return WxCpKfServicerListResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServiceStateResp getServiceState(String openKfid, String externalUserId) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/service_state/get");
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        json.addProperty("external_userid", externalUserId);
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfServiceStateResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServiceStateTransResp transServiceState(String openKfid, String externalUserId, Integer serviceState, String servicerUserId) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/service_state/trans");
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        json.addProperty("external_userid", externalUserId);
        json.addProperty("service_state", (Number)serviceState);
        json.addProperty("servicer_userid", servicerUserId);
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfServiceStateTransResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfMsgListResp syncMsg(String cursor, String token, Integer limit, Integer voiceFormat) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/sync_msg");
        JsonObject json = new JsonObject();
        if (cursor != null) {
            json.addProperty("cursor", cursor);
        }
        if (token != null) {
            json.addProperty("token", token);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        if (voiceFormat != null) {
            json.addProperty("voice_format", (Number)voiceFormat);
        }
        String responseContent = this.cpService.post(url, json);
        return WxCpKfMsgListResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfMsgListResp syncMsg(String cursor, String token, Integer limit, Integer voiceFormat, String openKfId) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/sync_msg");
        JsonObject json = new JsonObject();
        if (cursor != null) {
            json.addProperty("cursor", cursor);
        }
        if (token != null) {
            json.addProperty("token", token);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        if (voiceFormat != null) {
            json.addProperty("voice_format", (Number)voiceFormat);
        }
        if (openKfId != null) {
            json.addProperty("open_kfid", openKfId);
        }
        String responseContent = this.cpService.post(url, json);
        return WxCpKfMsgListResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfMsgSendResp sendMsg(WxCpKfMsgSendRequest request) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/send_msg");
        String responseContent = this.cpService.post(url, GSON.toJson((Object)request));
        return WxCpKfMsgSendResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfMsgSendResp sendMsgOnEvent(WxCpKfMsgSendRequest request) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/send_msg_on_event");
        String responseContent = this.cpService.post(url, GSON.toJson((Object)request));
        return WxCpKfMsgSendResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfCustomerBatchGetResp customerBatchGet(List<String> externalUserIdList) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/customer/batchget");
        JsonArray array = new JsonArray();
        externalUserIdList.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        JsonObject json = new JsonObject();
        json.add("external_userid_list", (JsonElement)array);
        String responseContent = this.cpService.post(url, json.toString());
        return WxCpKfCustomerBatchGetResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfServiceUpgradeConfigResp getUpgradeServiceConfig() throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/customer/get_upgrade_service_config");
        String response = this.cpService.get(url, null);
        return WxCpKfServiceUpgradeConfigResp.fromJson(response);
    }

    @Override
    public WxCpBaseResp upgradeMemberService(String openKfid, String externalUserId, String userid, String wording) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/customer/upgrade_service");
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        json.addProperty("external_userid", externalUserId);
        json.addProperty("type", (Number)1);
        JsonObject memberJson = new JsonObject();
        memberJson.addProperty("userid", userid);
        memberJson.addProperty("wording", wording);
        json.add("member", (JsonElement)memberJson);
        String response = this.cpService.post(url, json);
        return WxCpBaseResp.fromJson(response);
    }

    @Override
    public WxCpBaseResp upgradeGroupchatService(String openKfid, String externalUserId, String chatId, String wording) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/customer/upgrade_service");
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        json.addProperty("external_userid", externalUserId);
        json.addProperty("type", (Number)2);
        JsonObject groupchatJson = new JsonObject();
        groupchatJson.addProperty("chat_id", chatId);
        groupchatJson.addProperty("wording", wording);
        json.add("groupchat", (JsonElement)groupchatJson);
        String response = this.cpService.post(url, json);
        return WxCpBaseResp.fromJson(response);
    }

    @Override
    public WxCpBaseResp cancelUpgradeService(String openKfid, String externalUserId) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/customer/cancel_upgrade_service");
        JsonObject json = new JsonObject();
        json.addProperty("open_kfid", openKfid);
        json.addProperty("external_userid", externalUserId);
        String response = this.cpService.post(url, json);
        return WxCpBaseResp.fromJson(response);
    }

    @Override
    public WxCpKfGetCorpStatisticResp getCorpStatistic(WxCpKfGetCorpStatisticRequest request) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/get_corp_statistic");
        String responseContent = this.cpService.post(url, GSON.toJson((Object)request));
        return WxCpKfGetCorpStatisticResp.fromJson(responseContent);
    }

    @Override
    public WxCpKfGetServicerStatisticResp getServicerStatistic(WxCpKfGetServicerStatisticRequest request) throws WxErrorException {
        String url = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/kf/get_servicer_statistic");
        String responseContent = this.cpService.post(url, GSON.toJson((Object)request));
        return WxCpKfGetServicerStatisticResp.fromJson(responseContent);
    }

    public WxCpKfServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

