/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpOaScheduleService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.oa.WxCpOaSchedule;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpOaOaScheduleServiceImpl
implements WxCpOaScheduleService {
    private static final Logger log = LoggerFactory.getLogger(WxCpOaOaScheduleServiceImpl.class);
    private final WxCpService cpService;

    @Override
    public String add(WxCpOaSchedule schedule, Integer agentId) throws WxErrorException {
        ImmutableMap param = agentId == null ? ImmutableMap.of((Object)"schedule", (Object)schedule) : ImmutableMap.of((Object)"schedule", (Object)schedule, (Object)"agentid", (Object)agentId);
        return this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/schedule/add"), WxCpGsonBuilder.create().toJson((Object)param));
    }

    @Override
    public void update(WxCpOaSchedule schedule) throws WxErrorException {
        this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/schedule/update"), WxCpGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"schedule", (Object)schedule)));
    }

    @Override
    public List<WxCpOaSchedule> getDetails(List<String> scheduleIds) throws WxErrorException {
        String response = this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/schedule/get"), WxCpGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"schedule_id_list", scheduleIds)));
        return (List)WxCpGsonBuilder.create().fromJson(GsonParser.parse((String)response).get("schedule_list"), new TypeToken<List<WxCpOaSchedule>>(){}.getType());
    }

    @Override
    public void delete(String scheduleId) throws WxErrorException {
        this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/schedule/del"), WxCpGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"schedule_id", (Object)scheduleId)));
    }

    @Override
    public List<WxCpOaSchedule> listByCalendar(String calId, Integer offset, Integer limit) throws WxErrorException {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("cal_id", calId);
        if (offset != null) {
            param.put("offset", offset);
        }
        if (limit != null) {
            param.put("limit", limit);
        }
        String response = this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/oa/schedule/get_by_calendar"), WxCpGsonBuilder.create().toJson(param));
        return (List)WxCpGsonBuilder.create().fromJson(GsonParser.parse((String)response).get("schedule_list"), new TypeToken<List<WxCpOaSchedule>>(){}.getType());
    }

    public WxCpOaOaScheduleServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

