/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.List;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.cp.bean.workbench.WorkBenchKeyData;
import me.chanjar.weixin.cp.bean.workbench.WorkBenchList;

public class WxCpAgentWorkBench
implements Serializable {
    private static final long serialVersionUID = -4136604790232843229L;
    private String type;
    private String userId;
    private List<String> useridList;
    private Long agentId;
    private String jumpUrl;
    private String pagePath;
    private String url;
    private Boolean replaceUserData;
    private Boolean enableWebviewClick;
    private String height;
    private Boolean hideTitle;
    private List<WorkBenchKeyData> keyDataList;
    private List<WorkBenchList> lists;

    public String toTemplateString() {
        JsonObject templateObject = new JsonObject();
        templateObject.addProperty("agentid", (Number)this.agentId);
        templateObject.addProperty("type", this.type);
        if (this.replaceUserData != null) {
            templateObject.addProperty("replace_user_data", this.replaceUserData);
        }
        this.handle(templateObject);
        return templateObject.toString();
    }

    public String toUserDataString() {
        JsonObject userDataObject = new JsonObject();
        userDataObject.addProperty("agentid", (Number)this.agentId);
        userDataObject.addProperty("userid", this.userId);
        userDataObject.addProperty("type", this.type);
        this.handle(userDataObject);
        return userDataObject.toString();
    }

    public String toBatchUserDataString() {
        JsonObject userDataObject = new JsonObject();
        userDataObject.addProperty("agentid", (Number)this.agentId);
        JsonArray useridList = WxGsonBuilder.create().toJsonTree(this.useridList).getAsJsonArray();
        userDataObject.add("userid_list", (JsonElement)useridList);
        this.handleBatch(userDataObject);
        return userDataObject.toString();
    }

    private void handle(JsonObject templateObject) {
        switch (this.getType()) {
            case "keydata": {
                JsonArray keyDataArray = new JsonArray();
                JsonObject itemsObject = new JsonObject();
                for (WorkBenchKeyData keyDataItem : this.keyDataList) {
                    JsonObject keyDataObject = new JsonObject();
                    keyDataObject.addProperty("key", keyDataItem.getKey());
                    keyDataObject.addProperty("data", keyDataItem.getData());
                    keyDataObject.addProperty("jump_url", keyDataItem.getJumpUrl());
                    keyDataObject.addProperty("pagepath", keyDataItem.getPagePath());
                    keyDataArray.add((JsonElement)keyDataObject);
                }
                itemsObject.add("items", (JsonElement)keyDataArray);
                templateObject.add("keydata", (JsonElement)itemsObject);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("url", this.url);
                image.addProperty("jump_url", this.jumpUrl);
                image.addProperty("pagepath", this.pagePath);
                templateObject.add("image", (JsonElement)image);
                break;
            }
            case "list": {
                JsonArray listArray = new JsonArray();
                JsonObject itemsObject = new JsonObject();
                for (WorkBenchList listItem : this.lists) {
                    JsonObject listObject = new JsonObject();
                    listObject.addProperty("title", listItem.getTitle());
                    listObject.addProperty("jump_url", listItem.getJumpUrl());
                    listObject.addProperty("pagepath", listItem.getPagePath());
                    listArray.add((JsonElement)listObject);
                }
                itemsObject.add("items", (JsonElement)listArray);
                templateObject.add("list", (JsonElement)itemsObject);
                break;
            }
            case "webview": {
                JsonObject webview = new JsonObject();
                webview.addProperty("url", this.url);
                webview.addProperty("jump_url", this.jumpUrl);
                webview.addProperty("pagepath", this.pagePath);
                webview.addProperty("enable_webview_click", this.enableWebviewClick);
                webview.addProperty("height", this.height);
                webview.addProperty("hide_title", this.hideTitle);
                templateObject.add("webview", (JsonElement)webview);
                break;
            }
        }
    }

    private void handleBatch(JsonObject templateObject) {
        switch (this.getType()) {
            case "keydata": {
                JsonArray keyDataArray = new JsonArray();
                JsonObject itemsObject = new JsonObject();
                for (WorkBenchKeyData keyDataItem : this.keyDataList) {
                    JsonObject keyDataObject = new JsonObject();
                    keyDataObject.addProperty("key", keyDataItem.getKey());
                    keyDataObject.addProperty("data", keyDataItem.getData());
                    keyDataObject.addProperty("jump_url", keyDataItem.getJumpUrl());
                    keyDataObject.addProperty("pagepath", keyDataItem.getPagePath());
                    keyDataArray.add((JsonElement)keyDataObject);
                }
                itemsObject.add("items", (JsonElement)keyDataArray);
                JsonObject dataObject = new JsonObject();
                dataObject.addProperty("type", "keydata");
                dataObject.add("keydata", (JsonElement)itemsObject);
                templateObject.add("data", (JsonElement)dataObject);
                break;
            }
            case "image": {
                JsonObject image = new JsonObject();
                image.addProperty("url", this.url);
                image.addProperty("jump_url", this.jumpUrl);
                image.addProperty("pagepath", this.pagePath);
                JsonObject dataObject = new JsonObject();
                dataObject.addProperty("type", "image");
                dataObject.add("image", (JsonElement)image);
                templateObject.add("data", (JsonElement)dataObject);
                break;
            }
            case "list": {
                JsonArray listArray = new JsonArray();
                JsonObject itemsObject = new JsonObject();
                for (WorkBenchList listItem : this.lists) {
                    JsonObject listObject = new JsonObject();
                    listObject.addProperty("title", listItem.getTitle());
                    listObject.addProperty("jump_url", listItem.getJumpUrl());
                    listObject.addProperty("pagepath", listItem.getPagePath());
                    listArray.add((JsonElement)listObject);
                }
                itemsObject.add("items", (JsonElement)listArray);
                JsonObject dataObject = new JsonObject();
                dataObject.addProperty("type", "list");
                dataObject.add("list", (JsonElement)itemsObject);
                templateObject.add("data", (JsonElement)dataObject);
                break;
            }
            case "webview": {
                JsonObject webview = new JsonObject();
                webview.addProperty("url", this.url);
                webview.addProperty("jump_url", this.jumpUrl);
                webview.addProperty("pagepath", this.pagePath);
                webview.addProperty("enable_webview_click", this.enableWebviewClick);
                webview.addProperty("height", this.height);
                webview.addProperty("hide_title", this.hideTitle);
                JsonObject dataObject = new JsonObject();
                dataObject.addProperty("type", "webview");
                dataObject.add("webview", (JsonElement)webview);
                templateObject.add("data", (JsonElement)dataObject);
                break;
            }
        }
    }

    public static WxCpAgentWorkBenchBuilder builder() {
        return new WxCpAgentWorkBenchBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public List<String> getUseridList() {
        return this.useridList;
    }

    public Long getAgentId() {
        return this.agentId;
    }

    public String getJumpUrl() {
        return this.jumpUrl;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getReplaceUserData() {
        return this.replaceUserData;
    }

    public Boolean getEnableWebviewClick() {
        return this.enableWebviewClick;
    }

    public String getHeight() {
        return this.height;
    }

    public Boolean getHideTitle() {
        return this.hideTitle;
    }

    public List<WorkBenchKeyData> getKeyDataList() {
        return this.keyDataList;
    }

    public List<WorkBenchList> getLists() {
        return this.lists;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUseridList(List<String> useridList) {
        this.useridList = useridList;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setReplaceUserData(Boolean replaceUserData) {
        this.replaceUserData = replaceUserData;
    }

    public void setEnableWebviewClick(Boolean enableWebviewClick) {
        this.enableWebviewClick = enableWebviewClick;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setHideTitle(Boolean hideTitle) {
        this.hideTitle = hideTitle;
    }

    public void setKeyDataList(List<WorkBenchKeyData> keyDataList) {
        this.keyDataList = keyDataList;
    }

    public void setLists(List<WorkBenchList> lists) {
        this.lists = lists;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpAgentWorkBench)) {
            return false;
        }
        WxCpAgentWorkBench other = (WxCpAgentWorkBench)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$agentId = this.getAgentId();
        Long other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        Boolean this$replaceUserData = this.getReplaceUserData();
        Boolean other$replaceUserData = other.getReplaceUserData();
        if (this$replaceUserData == null ? other$replaceUserData != null : !((Object)this$replaceUserData).equals(other$replaceUserData)) {
            return false;
        }
        Boolean this$enableWebviewClick = this.getEnableWebviewClick();
        Boolean other$enableWebviewClick = other.getEnableWebviewClick();
        if (this$enableWebviewClick == null ? other$enableWebviewClick != null : !((Object)this$enableWebviewClick).equals(other$enableWebviewClick)) {
            return false;
        }
        Boolean this$hideTitle = this.getHideTitle();
        Boolean other$hideTitle = other.getHideTitle();
        if (this$hideTitle == null ? other$hideTitle != null : !((Object)this$hideTitle).equals(other$hideTitle)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        List<String> this$useridList = this.getUseridList();
        List<String> other$useridList = other.getUseridList();
        if (this$useridList == null ? other$useridList != null : !((Object)this$useridList).equals(other$useridList)) {
            return false;
        }
        String this$jumpUrl = this.getJumpUrl();
        String other$jumpUrl = other.getJumpUrl();
        if (this$jumpUrl == null ? other$jumpUrl != null : !this$jumpUrl.equals(other$jumpUrl)) {
            return false;
        }
        String this$pagePath = this.getPagePath();
        String other$pagePath = other.getPagePath();
        if (this$pagePath == null ? other$pagePath != null : !this$pagePath.equals(other$pagePath)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$height = this.getHeight();
        String other$height = other.getHeight();
        if (this$height == null ? other$height != null : !this$height.equals(other$height)) {
            return false;
        }
        List<WorkBenchKeyData> this$keyDataList = this.getKeyDataList();
        List<WorkBenchKeyData> other$keyDataList = other.getKeyDataList();
        if (this$keyDataList == null ? other$keyDataList != null : !((Object)this$keyDataList).equals(other$keyDataList)) {
            return false;
        }
        List<WorkBenchList> this$lists = this.getLists();
        List<WorkBenchList> other$lists = other.getLists();
        return !(this$lists == null ? other$lists != null : !((Object)this$lists).equals(other$lists));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpAgentWorkBench;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        Boolean $replaceUserData = this.getReplaceUserData();
        result = result * 59 + ($replaceUserData == null ? 43 : ((Object)$replaceUserData).hashCode());
        Boolean $enableWebviewClick = this.getEnableWebviewClick();
        result = result * 59 + ($enableWebviewClick == null ? 43 : ((Object)$enableWebviewClick).hashCode());
        Boolean $hideTitle = this.getHideTitle();
        result = result * 59 + ($hideTitle == null ? 43 : ((Object)$hideTitle).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        List<String> $useridList = this.getUseridList();
        result = result * 59 + ($useridList == null ? 43 : ((Object)$useridList).hashCode());
        String $jumpUrl = this.getJumpUrl();
        result = result * 59 + ($jumpUrl == null ? 43 : $jumpUrl.hashCode());
        String $pagePath = this.getPagePath();
        result = result * 59 + ($pagePath == null ? 43 : $pagePath.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : $height.hashCode());
        List<WorkBenchKeyData> $keyDataList = this.getKeyDataList();
        result = result * 59 + ($keyDataList == null ? 43 : ((Object)$keyDataList).hashCode());
        List<WorkBenchList> $lists = this.getLists();
        result = result * 59 + ($lists == null ? 43 : ((Object)$lists).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpAgentWorkBench(type=" + this.getType() + ", userId=" + this.getUserId() + ", useridList=" + this.getUseridList() + ", agentId=" + this.getAgentId() + ", jumpUrl=" + this.getJumpUrl() + ", pagePath=" + this.getPagePath() + ", url=" + this.getUrl() + ", replaceUserData=" + this.getReplaceUserData() + ", enableWebviewClick=" + this.getEnableWebviewClick() + ", height=" + this.getHeight() + ", hideTitle=" + this.getHideTitle() + ", keyDataList=" + this.getKeyDataList() + ", lists=" + this.getLists() + ")";
    }

    public WxCpAgentWorkBench() {
    }

    public WxCpAgentWorkBench(String type, String userId, List<String> useridList, Long agentId, String jumpUrl, String pagePath, String url, Boolean replaceUserData, Boolean enableWebviewClick, String height, Boolean hideTitle, List<WorkBenchKeyData> keyDataList, List<WorkBenchList> lists) {
        this.type = type;
        this.userId = userId;
        this.useridList = useridList;
        this.agentId = agentId;
        this.jumpUrl = jumpUrl;
        this.pagePath = pagePath;
        this.url = url;
        this.replaceUserData = replaceUserData;
        this.enableWebviewClick = enableWebviewClick;
        this.height = height;
        this.hideTitle = hideTitle;
        this.keyDataList = keyDataList;
        this.lists = lists;
    }

    public static class WxCpAgentWorkBenchBuilder {
        private String type;
        private String userId;
        private List<String> useridList;
        private Long agentId;
        private String jumpUrl;
        private String pagePath;
        private String url;
        private Boolean replaceUserData;
        private Boolean enableWebviewClick;
        private String height;
        private Boolean hideTitle;
        private List<WorkBenchKeyData> keyDataList;
        private List<WorkBenchList> lists;

        WxCpAgentWorkBenchBuilder() {
        }

        public WxCpAgentWorkBenchBuilder type(String type) {
            this.type = type;
            return this;
        }

        public WxCpAgentWorkBenchBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public WxCpAgentWorkBenchBuilder useridList(List<String> useridList) {
            this.useridList = useridList;
            return this;
        }

        public WxCpAgentWorkBenchBuilder agentId(Long agentId) {
            this.agentId = agentId;
            return this;
        }

        public WxCpAgentWorkBenchBuilder jumpUrl(String jumpUrl) {
            this.jumpUrl = jumpUrl;
            return this;
        }

        public WxCpAgentWorkBenchBuilder pagePath(String pagePath) {
            this.pagePath = pagePath;
            return this;
        }

        public WxCpAgentWorkBenchBuilder url(String url) {
            this.url = url;
            return this;
        }

        public WxCpAgentWorkBenchBuilder replaceUserData(Boolean replaceUserData) {
            this.replaceUserData = replaceUserData;
            return this;
        }

        public WxCpAgentWorkBenchBuilder enableWebviewClick(Boolean enableWebviewClick) {
            this.enableWebviewClick = enableWebviewClick;
            return this;
        }

        public WxCpAgentWorkBenchBuilder height(String height) {
            this.height = height;
            return this;
        }

        public WxCpAgentWorkBenchBuilder hideTitle(Boolean hideTitle) {
            this.hideTitle = hideTitle;
            return this;
        }

        public WxCpAgentWorkBenchBuilder keyDataList(List<WorkBenchKeyData> keyDataList) {
            this.keyDataList = keyDataList;
            return this;
        }

        public WxCpAgentWorkBenchBuilder lists(List<WorkBenchList> lists) {
            this.lists = lists;
            return this;
        }

        public WxCpAgentWorkBench build() {
            return new WxCpAgentWorkBench(this.type, this.userId, this.useridList, this.agentId, this.jumpUrl, this.pagePath, this.url, this.replaceUserData, this.enableWebviewClick, this.height, this.hideTitle, this.keyDataList, this.lists);
        }

        public String toString() {
            return "WxCpAgentWorkBench.WxCpAgentWorkBenchBuilder(type=" + this.type + ", userId=" + this.userId + ", useridList=" + this.useridList + ", agentId=" + this.agentId + ", jumpUrl=" + this.jumpUrl + ", pagePath=" + this.pagePath + ", url=" + this.url + ", replaceUserData=" + this.replaceUserData + ", enableWebviewClick=" + this.enableWebviewClick + ", height=" + this.height + ", hideTitle=" + this.hideTitle + ", keyDataList=" + this.keyDataList + ", lists=" + this.lists + ")";
        }
    }
}

