/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.open.api.WxOpenMaShoppingOrdersService;
import me.chanjar.weixin.open.bean.result.WxOpenResult;
import me.chanjar.weixin.open.bean.shoppingOrders.CombinedShippingInfo;
import me.chanjar.weixin.open.bean.shoppingOrders.CombinedShoppingInfo;
import me.chanjar.weixin.open.bean.shoppingOrders.ShippingInfo;
import me.chanjar.weixin.open.bean.shoppingOrders.ShoppingInfo;
import me.chanjar.weixin.open.bean.shoppingOrders.ShoppingInfoVerifyUpload;
import me.chanjar.weixin.open.bean.shoppingOrders.WxOpenShoppingInfoVerifyUploadResult;
import me.chanjar.weixin.open.bean.shoppingOrders.WxOpenShoppingOrdersConfirmResult;
import me.chanjar.weixin.open.util.json.WxOpenGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxOpenMaShoppingOrdersServiceImpl
implements WxOpenMaShoppingOrdersService {
    private static final Logger log = LoggerFactory.getLogger(WxOpenMaShoppingOrdersServiceImpl.class);
    private final WxMaService wxMaService;

    @Override
    public WxOpenResult upload(ShoppingInfo info) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/user-order/orders", WxOpenGsonBuilder.create().toJson((Object)info));
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult upload(ShippingInfo info) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/user-order/orders/shippings", WxOpenGsonBuilder.create().toJson((Object)info));
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult upload(CombinedShoppingInfo info) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/user-order/combine-orders", WxOpenGsonBuilder.create().toJson((Object)info));
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult upload(CombinedShippingInfo info) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/user-order/combine-orders/shippings", WxOpenGsonBuilder.create().toJson((Object)info));
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult openShoppingOrderProductPermission() throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/user-order/orders-permission/open", "");
        return (WxOpenResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenShoppingOrdersConfirmResult confirmProductPermission() throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/user-order/orders-permission/confirm", "");
        return (WxOpenShoppingOrdersConfirmResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenShoppingOrdersConfirmResult.class);
    }

    @Override
    public WxOpenShoppingInfoVerifyUploadResult verifyUploadResult(ShoppingInfoVerifyUpload info) throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/user-order/shoppinginfo/verify", WxOpenGsonBuilder.create().toJson((Object)info));
        return (WxOpenShoppingInfoVerifyUploadResult)WxOpenGsonBuilder.create().fromJson(response, WxOpenShoppingInfoVerifyUploadResult.class);
    }

    public WxOpenMaShoppingOrdersServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

