/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import me.chanjar.weixin.open.api.WxOpenMinishopService;
import me.chanjar.weixin.open.bean.minishop.MinishopAuditStatus;
import me.chanjar.weixin.open.bean.minishop.MinishopBrandList;
import me.chanjar.weixin.open.bean.minishop.MinishopBusiLicense;
import me.chanjar.weixin.open.bean.minishop.MinishopCategories;
import me.chanjar.weixin.open.bean.minishop.MinishopIdcardInfo;
import me.chanjar.weixin.open.bean.minishop.MinishopNameInfo;
import me.chanjar.weixin.open.bean.minishop.MinishopOrganizationCodeInfo;
import me.chanjar.weixin.open.bean.minishop.MinishopReturnInfo;
import me.chanjar.weixin.open.bean.minishop.MinishopShopCatList;
import me.chanjar.weixin.open.bean.minishop.MinishopSuperAdministratorInfo;
import me.chanjar.weixin.open.bean.result.WxOpenResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxOpenMinishopServiceImpl
extends WxMaServiceImpl
implements WxOpenMinishopService {
    private static final Logger log = LoggerFactory.getLogger(WxOpenMinishopServiceImpl.class);
    private final WxOpenComponentService wxOpenComponentService;
    private final WxMaConfig wxMaConfig;
    private final String appId;

    public WxOpenMinishopServiceImpl(WxOpenComponentService wxOpenComponentService, String appId, WxMaConfig wxMaConfig) {
        this.wxOpenComponentService = wxOpenComponentService;
        this.appId = appId;
        this.wxMaConfig = wxMaConfig;
        log.info("appId: {}", (Object)appId);
        if (wxMaConfig == null) {
            log.error("WxMaConfig is null");
        }
        this.addConfig(appId, wxMaConfig);
        this.initHttp();
    }

    @Override
    public WxOpenResult submitMerchantInfo(String appId, String subjectType, MinishopBusiLicense busiLicense, MinishopOrganizationCodeInfo organizationCodeInfo, MinishopIdcardInfo idcardInfo, MinishopSuperAdministratorInfo superAdministratorInfo, String merchantShoprtName) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("app_id", appId);
        jsonObject.addProperty("subject_type", subjectType);
        jsonObject.add("busi_license", (JsonElement)busiLicense.toJsonObject());
        jsonObject.add("organization_code_info", (JsonElement)organizationCodeInfo.toJsonObject());
        jsonObject.add("id_card_info", (JsonElement)idcardInfo.toJsonObject());
        jsonObject.add("super_administrator_info", (JsonElement)superAdministratorInfo.toJsonObject());
        String response = this.post("https://api.weixin.qq.com/product/register/submit_merchantinfo", jsonObject.toString());
        return null;
    }

    @Override
    public WxOpenResult submitBasicInfo(String appId, MinishopNameInfo nameInfo, MinishopReturnInfo returnInfo) {
        return null;
    }

    @Override
    public MinishopAuditStatus checkAuditStatus(String wxName) throws WxErrorException {
        return null;
    }

    @Override
    public String uploadImagePicFile(Integer height, Integer width, File file) throws WxErrorException {
        String url = "https://api.weixin.qq.com/product/img/upload?access_token=" + this.getAccessToken(true) + "&height=" + height + "&width=" + width;
        log.info("upload url: {}", (Object)url);
        String response = this.post(url, file);
        return response;
    }

    @Override
    public MinishopCategories getCategory(Integer fCatId) {
        return null;
    }

    @Override
    public MinishopBrandList getBrands() {
        return null;
    }

    @Override
    public MinishopShopCatList getShopCat() {
        return null;
    }
}

