/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import java.io.File;
import me.chanjar.weixin.common.bean.result.WxMinishopImageUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.common.util.http.MinishopUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.common.util.http.apache.DefaultApacheHttpClientBuilder;
import me.chanjar.weixin.open.api.WxOpenConfigStorage;
import me.chanjar.weixin.open.api.impl.WxOpenServiceAbstractImpl;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public class WxOpenServiceApacheHttpClientImpl
extends WxOpenServiceAbstractImpl<CloseableHttpClient, HttpHost> {
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;

    @Override
    public void initHttp() {
        WxOpenConfigStorage configStorage = this.getWxOpenConfigStorage();
        ApacheHttpClientBuilder apacheHttpClientBuilder = configStorage.getApacheHttpClientBuilder();
        if (null == apacheHttpClientBuilder) {
            apacheHttpClientBuilder = DefaultApacheHttpClientBuilder.get();
        }
        apacheHttpClientBuilder.httpProxyHost(configStorage.getHttpProxyHost()).httpProxyPort(configStorage.getHttpProxyPort()).httpProxyUsername(configStorage.getHttpProxyUsername()).httpProxyPassword(configStorage.getHttpProxyPassword());
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.APACHE_HTTP;
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public WxMinishopImageUploadResult uploadMinishopMediaFile(String url, File file) throws WxErrorException {
        return (WxMinishopImageUploadResult)this.execute(MinishopUploadRequestExecutor.create((RequestHttp)this), url, file);
    }
}

