/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.open.bean.auth.WxOpenAuthorizerInfo;
import me.chanjar.weixin.open.util.json.WxOpenGsonBuilder;

public class WxOpenAuthorizerInfoGsonAdapter
implements JsonDeserializer<WxOpenAuthorizerInfo> {
    private static final String VERIFY_TYPE_INFO = "verify_type_info";
    private static final String SERVICE_TYPE_INFO = "service_type_info";
    private static final String MINI_PROGRAM_INFO = "MiniProgramInfo";
    private static final String BASIC_CONFIG = "basic_config";

    public WxOpenAuthorizerInfo deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        WxOpenAuthorizerInfo authorizationInfo = new WxOpenAuthorizerInfo();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        authorizationInfo.setNickName(GsonHelper.getString((JsonObject)jsonObject, (String)"nick_name"));
        authorizationInfo.setHeadImg(GsonHelper.getString((JsonObject)jsonObject, (String)"head_img"));
        authorizationInfo.setUserName(GsonHelper.getString((JsonObject)jsonObject, (String)"user_name"));
        authorizationInfo.setPrincipalName(GsonHelper.getString((JsonObject)jsonObject, (String)"principal_name"));
        authorizationInfo.setAlias(GsonHelper.getString((JsonObject)jsonObject, (String)"alias"));
        authorizationInfo.setQrcodeUrl(GsonHelper.getString((JsonObject)jsonObject, (String)"qrcode_url"));
        authorizationInfo.setAccountStatus(GsonHelper.getInteger((JsonObject)jsonObject, (String)"account_status"));
        authorizationInfo.setSignature(GsonHelper.getString((JsonObject)jsonObject, (String)"signature"));
        authorizationInfo.setRegisterType(GsonHelper.getInteger((JsonObject)jsonObject, (String)"register_type"));
        if (jsonObject.has(SERVICE_TYPE_INFO)) {
            authorizationInfo.setServiceTypeInfo(GsonHelper.getInteger((JsonObject)jsonObject.getAsJsonObject(SERVICE_TYPE_INFO), (String)"id"));
        }
        if (jsonObject.has(VERIFY_TYPE_INFO)) {
            authorizationInfo.setVerifyTypeInfo(GsonHelper.getInteger((JsonObject)jsonObject.getAsJsonObject(VERIFY_TYPE_INFO), (String)"id"));
        }
        if (jsonObject.has(BASIC_CONFIG)) {
            authorizationInfo.setBasicConfig((WxOpenAuthorizerInfo.BasicConfig)WxOpenGsonBuilder.create().fromJson(jsonObject.get(BASIC_CONFIG), new TypeToken<WxOpenAuthorizerInfo.BasicConfig>(){}.getType()));
        }
        Map businessInfo = (Map)WxOpenGsonBuilder.create().fromJson(jsonObject.get("business_info"), new TypeToken<Map<String, Integer>>(){}.getType());
        authorizationInfo.setBusinessInfo(businessInfo);
        if (jsonObject.has(MINI_PROGRAM_INFO)) {
            WxOpenAuthorizerInfo.MiniProgramInfo miniProgramInfo = (WxOpenAuthorizerInfo.MiniProgramInfo)WxOpenGsonBuilder.create().fromJson(jsonObject.get(MINI_PROGRAM_INFO), new TypeToken<WxOpenAuthorizerInfo.MiniProgramInfo>(){}.getType());
            authorizationInfo.setMiniProgramInfo(miniProgramInfo);
        }
        return authorizationInfo;
    }
}

