/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.applyconfirm.ApplySubjectConfirmCreateRequest;
import com.github.binarywang.wxpay.bean.applyconfirm.ApplySubjectConfirmCreateResult;
import com.github.binarywang.wxpay.bean.applyconfirm.ApplySubjectConfirmMerchantStateQueryResult;
import com.github.binarywang.wxpay.bean.applyconfirm.ApplySubjectConfirmStateQueryResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.Apply4SubjectConfirmService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Apply4SubjectConfirmServiceImpl
implements Apply4SubjectConfirmService {
    private static final Logger log = LoggerFactory.getLogger(Apply4SubjectConfirmServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public ApplySubjectConfirmCreateResult applyment(ApplySubjectConfirmCreateRequest request) throws WxPayException {
        String url = String.format("%s/v3/apply4subject/applyment", this.payService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.payService.getConfig().getVerifier().getValidCertificate());
        String result = this.payService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (ApplySubjectConfirmCreateResult)GSON.fromJson(result, ApplySubjectConfirmCreateResult.class);
    }

    @Override
    public ApplySubjectConfirmStateQueryResult queryApplyStatusByBusinessCode(String businessCode) throws WxPayException {
        String url = String.format("%s/v3/apply4subject/applyment?business_code=%s", this.payService.getPayBaseUrl(), businessCode);
        String result = this.payService.getV3(url);
        return (ApplySubjectConfirmStateQueryResult)GSON.fromJson(result, ApplySubjectConfirmStateQueryResult.class);
    }

    @Override
    public ApplySubjectConfirmStateQueryResult queryApplyStatusByApplymentId(String applymentId) throws WxPayException {
        String url = String.format("%s/v3/apply4subject/applyment?applyment_id=%s", this.payService.getPayBaseUrl(), applymentId);
        String result = this.payService.getV3(url);
        return (ApplySubjectConfirmStateQueryResult)GSON.fromJson(result, ApplySubjectConfirmStateQueryResult.class);
    }

    @Override
    public ApplySubjectConfirmMerchantStateQueryResult queryMerchantApplyStatusByMchId(String subMchId) throws WxPayException {
        String url = String.format("%s/v3/apply4subject/applyment/merchants/%s/state", this.payService.getPayBaseUrl(), subMchId);
        String result = this.payService.getV3(url);
        return (ApplySubjectConfirmMerchantStateQueryResult)GSON.fromJson(result, ApplySubjectConfirmMerchantStateQueryResult.class);
    }

    @Override
    public void cancelApplyByBusinessCode(String businessCode) throws WxPayException {
        String url = String.format("%s/v3/apply4subject/applyment/%s/cancel", this.payService.getPayBaseUrl(), businessCode);
        this.payService.postV3WithWechatpaySerial(url, "");
    }

    @Override
    public void cancelApplyByApplymentId(String applymentId) throws WxPayException {
        String url = String.format("%s/v3/apply4subject/applyment/%s/cancel", this.payService.getPayBaseUrl(), applymentId);
        this.payService.postV3WithWechatpaySerial(url, "");
    }

    public Apply4SubjectConfirmServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

