/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.miniapp.config;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={WxMaService.class})
@EnableConfigurationProperties(value={WxMaProperties.class})
@ConditionalOnProperty(prefix="wx.miniapp", value={"enabled"}, matchIfMissing=true)
public class WxMaAutoConfiguration {
    private WxMaProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={WxMaService.class})
    public WxMaService service() {
        WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
        config.setAppid(StringUtils.trimToNull((String)this.properties.getAppid()));
        config.setSecret(StringUtils.trimToNull((String)this.properties.getSecret()));
        config.setToken(StringUtils.trimToNull((String)this.properties.getToken()));
        config.setAesKey(StringUtils.trimToNull((String)this.properties.getAesKey()));
        config.setMsgDataFormat(StringUtils.trimToNull((String)this.properties.getMsgDataFormat()));
        WxMaServiceImpl service = new WxMaServiceImpl();
        service.setWxMaConfig((WxMaConfig)config);
        return service;
    }

    public WxMaAutoConfiguration(WxMaProperties properties) {
        this.properties = properties;
    }
}

