/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.hibernate.AbstractHazelcastCacheRegionFactory;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.PhoneHomeInfo;
import com.hazelcast.hibernate.PhoneHomeService;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.hibernate.local.TimestampsRegionCache;
import com.hazelcast.internal.util.Clock;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class HazelcastLocalCacheRegionFactory
extends AbstractHazelcastCacheRegionFactory {
    private static final PhoneHomeInfo PHONE_HOME_INFO = new PhoneHomeInfo(true);

    public HazelcastLocalCacheRegionFactory() {
    }

    public HazelcastLocalCacheRegionFactory(CacheKeysFactory cacheKeysFactory) {
        super(cacheKeysFactory);
    }

    public HazelcastLocalCacheRegionFactory(PhoneHomeService phoneHomeService) {
        super(phoneHomeService);
    }

    @Override
    protected RegionCache createRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory, DomainDataRegionConfig regionConfig) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        LocalRegionCache regionCache = LocalRegionCache.builder().withRegionFactory((RegionFactory)this).withName(qualifiedRegionName).withHazelcastInstance(this.instance).withRegionConfig(regionConfig).withTopic(true).withFreeHeapBasedCacheEvictor(this.freeHeapBasedCacheEvictor).build();
        this.localRegionCaches.add(regionCache);
        return regionCache;
    }

    @Override
    protected RegionCache createTimestampsRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        TimestampsRegionCache timestampsRegionCache = new TimestampsRegionCache((RegionFactory)this, qualifiedRegionName, this.instance, this.freeHeapBasedCacheEvictor);
        this.localRegionCaches.add(timestampsRegionCache);
        return timestampsRegionCache;
    }

    @Override
    PhoneHomeInfo phoneHomeInfo() {
        return PHONE_HOME_INFO;
    }

    public long nextTimestamp() {
        return this.instance == null ? Clock.currentTimeMillis() : HazelcastTimestamper.nextTimestamp(this.instance);
    }
}

