/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.hibernate.PhoneHomeInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class PhoneHomeService {
    private static final String SYS_PHONE_HOME_ENABLED = "hazelcast.phone.home.enabled";
    private static final String ENV_PHONE_HOME_ENABLED = "HZ_PHONE_HOME_ENABLED";
    private static final Duration TIMEOUT = Duration.ofMillis(3000L);
    private static final int RETRY_COUNT = 5;
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(0, r -> {
        Thread t = new Thread(r, "Hazelcast-Hibernate.PhoneHomeService");
        t.setDaemon(true);
        return t;
    });
    private final ILogger logger = Logger.getLogger(PhoneHomeService.class);
    private final AtomicBoolean started = new AtomicBoolean();
    private final String baseUrl;
    private final PhoneHomeInfo phoneHomeInfo;
    private ScheduledFuture<?> sendFuture;

    PhoneHomeService(PhoneHomeInfo phoneHomeInfo) {
        this("http://phonehome.hazelcast.com/pingIntegrations/hazelcast-hibernate53", phoneHomeInfo);
    }

    PhoneHomeService(String baseUrl, PhoneHomeInfo phoneHomeInfo) {
        this.baseUrl = baseUrl;
        this.phoneHomeInfo = phoneHomeInfo;
    }

    private static boolean isPhoneHomeEnabled() {
        if (Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty(SYS_PHONE_HOME_ENABLED))) {
            return false;
        }
        return !Boolean.FALSE.toString().equalsIgnoreCase(System.getenv(ENV_PHONE_HOME_ENABLED));
    }

    void start() {
        if (PhoneHomeService.isPhoneHomeEnabled() && this.started.compareAndSet(false, true)) {
            this.sendFuture = executor.scheduleAtFixedRate(this::send, 0L, 1L, TimeUnit.DAYS);
        }
    }

    private void send() {
        int retryCount = 5;
        boolean succeed = false;
        while (retryCount-- > 0 && !succeed) {
            try (BufferedInputStream ignored = new BufferedInputStream(this.getUrlConnection().getInputStream());){
                succeed = true;
            }
            catch (Exception e) {
                if (!this.logger.isFineEnabled()) continue;
                this.logger.fine("Failed to establish home phone call. Retries left: " + retryCount, (Throwable)e);
            }
        }
    }

    private URLConnection getUrlConnection() throws IOException {
        URL url = new URL(this.baseUrl + this.phoneHomeInfo.getQueryString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        conn.setConnectTimeout((int)TIMEOUT.toMillis());
        conn.setReadTimeout((int)TIMEOUT.toMillis());
        return conn;
    }

    void shutdown() {
        if (this.sendFuture != null) {
            this.sendFuture.cancel(false);
        }
    }

    static {
        executor.setRemoveOnCancelPolicy(true);
    }
}

