/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.wsdl.builder;

import com.liferay.gradle.util.GradleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.tasks.Input;

public class GenerateOptions {
    private boolean _backwordCompatible;
    private Databinding _databinding;
    private boolean _flattenFiles;
    private boolean _generateAll;
    private final Map<Object, Object> _mappings = new TreeMap<Object, Object>();
    private boolean _noWrapped;
    private boolean _serverSide;
    private boolean _verbose;

    @Input
    public Databinding getDatabinding() {
        return this._databinding;
    }

    @Input
    public Map<?, ?> getMappings() {
        return this._mappings;
    }

    @Input
    public boolean isBackwordCompatible() {
        return this._backwordCompatible;
    }

    @Input
    public boolean isFlattenFiles() {
        return this._flattenFiles;
    }

    @Input
    public boolean isGenerateAll() {
        return this._generateAll;
    }

    @Input
    public boolean isNoWrapped() {
        return this._noWrapped;
    }

    @Input
    public boolean isServerSide() {
        return this._serverSide;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public GenerateOptions mapping(Object namespace, Object packageName) {
        this._mappings.put(namespace, packageName);
        return this;
    }

    public GenerateOptions mappings(Map<?, ?> mappings) {
        this._mappings.putAll(mappings);
        return this;
    }

    public void setBackwordCompatible(boolean backwordCompatible) {
        this._backwordCompatible = backwordCompatible;
    }

    public void setDatabinding(Databinding databinding) {
        this._databinding = databinding;
    }

    public void setFlattenFiles(boolean flattenFiles) {
        this._flattenFiles = flattenFiles;
    }

    public void setGenerateAll(boolean generateAll) {
        this._generateAll = generateAll;
    }

    public void setMappings(Map<?, ?> mappings) {
        this._mappings.clear();
        this.mappings(mappings);
    }

    public void setNoWrapped(boolean noWrapped) {
        this._noWrapped = noWrapped;
    }

    public void setServerSide(boolean serverSide) {
        this._serverSide = serverSide;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    protected List<String> getArgs() {
        Map<?, ?> mappings;
        Databinding databinding;
        ArrayList<String> args = new ArrayList<String>();
        if (this.isBackwordCompatible()) {
            args.add("--backword-compatible");
        }
        if ((databinding = this.getDatabinding()) != null) {
            args.add("--databinding-method");
            String name = databinding.name();
            args.add(name.toLowerCase());
        }
        if (this.isFlattenFiles()) {
            args.add("--flatten-files");
        }
        if (this.isGenerateAll()) {
            args.add("--generate-all");
        }
        if (this.isNoWrapped()) {
            args.add("--noWrapped");
        }
        if (!(mappings = this.getMappings()).isEmpty()) {
            for (Map.Entry<?, ?> entry : mappings.entrySet()) {
                args.add("--NStoPkg");
                String namespace = GradleUtil.toString(entry.getKey());
                String packageName = GradleUtil.toString(entry.getValue());
                args.add(namespace + "=" + packageName);
            }
        }
        if (this.isServerSide()) {
            args.add("--server-side");
        }
        if (this.isVerbose()) {
            args.add("--verbose");
        }
        return args;
    }

    public static enum Databinding {
        ADB,
        JIBX,
        NONE,
        XMLBEANS;

    }
}

