/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.constants;

import com.openhtmltopdf.css.parser.CSSPrimitiveValue;
import com.openhtmltopdf.util.GeneralUtil;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import com.openhtmltopdf.util.XRRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public final class ValueConstants {
    private static final List<String> TYPE_DESCRIPTIONS;
    private static final Map<Short, String> sacTypesStrings;

    public static String stringForSACPrimitiveType(short type) {
        return sacTypesStrings.get(new Short(type));
    }

    public static boolean isAbsoluteUnit(short type) {
        switch (type) {
            case 2: {
                return false;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
            case 0: {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.CASCADE_IS_ABSOLUTE_CSS_UNKNOWN_GIVEN);
                GeneralUtil.dumpShortException(new Exception());
            }
        }
        return false;
    }

    public static boolean isNumber(short cssPrimitiveType) {
        switch (cssPrimitiveType) {
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    static {
        TreeMap<Short, String> map = new TreeMap<Short, String>();
        TYPE_DESCRIPTIONS = new ArrayList<String>();
        try {
            Field[] fields = CSSPrimitiveValue.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                int mod = f.getModifiers();
                if (!Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
                Short val = (Short)f.get(null);
                String name = f.getName();
                if (!name.startsWith("CSS_") || name.equals("CSS_INHERIT") || name.equals("CSS_PRIMITIVE_VALUE") || name.equals("CSS_VALUE_LIST") || name.equals("CSS_CUSTOM")) continue;
                map.put(val, name.substring("CSS_".length()));
            }
            ArrayList keys = new ArrayList(map.keySet());
            Collections.sort(keys);
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                TYPE_DESCRIPTIONS.add((String)map.get(iter.next()));
            }
        }
        catch (Exception ex) {
            throw new XRRuntimeException("Could not build static list of CSS type descriptions.", ex);
        }
        sacTypesStrings = new HashMap<Short, String>(25);
        sacTypesStrings.put(new Short(3), "em");
        sacTypesStrings.put(new Short(4), "ex");
        sacTypesStrings.put(new Short(5), "px");
        sacTypesStrings.put(new Short(2), "%");
        sacTypesStrings.put(new Short(8), "in");
        sacTypesStrings.put(new Short(6), "cm");
        sacTypesStrings.put(new Short(7), "mm");
        sacTypesStrings.put(new Short(9), "pt");
        sacTypesStrings.put(new Short(10), "pc");
    }
}

