/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.svgsupport;

import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.svgsupport.BatikSVGImage;
import com.openhtmltopdf.svgsupport.PDFTranscoder;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class BatikSVGDrawer
implements SVGDrawer {
    private final Set<String> allowedProtocols;
    public PDFTranscoder.OpenHtmlFontResolver fontResolver;
    private final boolean allowScripts;
    private final boolean allowExternalResources;
    private UserAgentCallback userAgentCallback;

    public BatikSVGDrawer(SvgScriptMode scriptMode, SvgExternalResourceMode externalResourceMode) {
        this.allowScripts = scriptMode == SvgScriptMode.INSECURE_ALLOW_SCRIPTS;
        this.allowExternalResources = externalResourceMode == SvgExternalResourceMode.INSECURE_ALLOW_EXTERNAL_RESOURCE_REQUESTS;
        this.allowedProtocols = null;
    }

    public BatikSVGDrawer(SvgScriptMode scriptMode, Set<String> allowedProtocols) {
        this.allowScripts = scriptMode == SvgScriptMode.INSECURE_ALLOW_SCRIPTS;
        this.allowExternalResources = false;
        this.allowedProtocols = Collections.unmodifiableSet(allowedProtocols);
    }

    public BatikSVGDrawer() {
        this(SvgScriptMode.SECURE, SvgExternalResourceMode.SECURE);
    }

    public void importFontFaceRules(List<FontFaceRule> fontFaces, SharedContext shared) {
        this.fontResolver = new PDFTranscoder.OpenHtmlFontResolver();
        this.fontResolver.importFontFaces(fontFaces, shared);
    }

    public void withUserAgent(UserAgentCallback userAgentCallback) {
        this.userAgentCallback = userAgentCallback;
    }

    public SVGDrawer.SVGImage buildSVGImage(Element svgElement, Box box, CssContext c, double cssWidth, double cssHeight, double dotsPerPixel) {
        double cssMaxWidth = CalculatedStyle.getCSSMaxWidth((CssContext)c, (Box)box);
        double cssMaxHeight = CalculatedStyle.getCSSMaxHeight((CssContext)c, (Box)box);
        BatikSVGImage img = new BatikSVGImage(svgElement, box, cssWidth, cssHeight, cssMaxWidth, cssMaxHeight, dotsPerPixel, c);
        img.setFontResolver(this.fontResolver);
        img.setUserAgentCallback(this.userAgentCallback);
        img.setSecurityOptions(this.allowScripts, this.allowExternalResources, this.allowedProtocols);
        return img;
    }

    public void close() {
    }

    public void addFontFile(File fontFile, String family, Integer weight, BaseRendererBuilder.FontStyle style) throws IOException, FontFormatException {
        this.fontResolver.addFontFile(fontFile, family, weight, style);
    }

    public static enum SvgExternalResourceMode {
        SECURE,
        INSECURE_ALLOW_EXTERNAL_RESOURCE_REQUESTS;

    }

    public static enum SvgScriptMode {
        SECURE,
        INSECURE_ALLOW_SCRIPTS;

    }
}

