/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.amd64;

import com.oracle.svm.core.FrameAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.AMD64.class})
public final class AMD64FrameAccess
extends FrameAccess {
    @Override
    public CodePointer readReturnAddress(Pointer sourceSp) {
        return (CodePointer)sourceSp.readWord(-AMD64FrameAccess.returnAddressSize());
    }

    @Override
    public void writeReturnAddress(Pointer sourceSp, CodePointer newReturnAddress) {
        sourceSp.writeWord(-AMD64FrameAccess.returnAddressSize(), (WordBase)newReturnAddress);
    }
}

