/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.WordFactory;

public final class CEntryPointBuiltins {
    private static final String UNINTERRUPTIBLE_REASON = "Unsafe state in case of failure";

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    public static Isolate createIsolate() {
        Isolate result = (Isolate)WordFactory.nullPointer();
        int status = CEntryPointActions.enterCreateIsolate((CEntryPointCreateIsolateParameters)WordFactory.nullPointer());
        if (status == 0) {
            result = CurrentIsolate.getIsolate();
            CEntryPointActions.leave();
        }
        return result;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    public static IsolateThread attachThread(Isolate isolate) {
        IsolateThread result = (IsolateThread)WordFactory.nullPointer();
        int status = CEntryPointActions.enterAttachThread(isolate);
        if (status == 0) {
            result = CurrentIsolate.getCurrentThread();
            status = CEntryPointActions.leave();
        }
        return result;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    public static IsolateThread currentThread(Isolate isolate) {
        int status = CEntryPointActions.enterIsolate(isolate);
        if (status != 0) {
            return (IsolateThread)WordFactory.nullPointer();
        }
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        if (CEntryPointActions.leave() != 0) {
            thread = (IsolateThread)WordFactory.nullPointer();
        }
        return thread;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    public static Isolate currentIsolate(IsolateThread thread) {
        int status = CEntryPointActions.enter(thread);
        if (status != 0) {
            return (Isolate)WordFactory.nullPointer();
        }
        Isolate isolate = CurrentIsolate.getIsolate();
        if (CEntryPointActions.leave() != 0) {
            isolate = (Isolate)WordFactory.nullPointer();
        }
        return isolate;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    public static int detachThread(IsolateThread thread) {
        int status = CEntryPointActions.enter(thread);
        if (status != 0) {
            CEntryPointActions.leave();
            return status;
        }
        status = CEntryPointActions.leaveDetachThread();
        return status;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    public static int tearDownIsolate(Isolate isolate) {
        int result = CEntryPointActions.enterAttachThread(isolate);
        if (result != 0) {
            CEntryPointActions.leave();
            return result;
        }
        result = CEntryPointActions.leaveTearDownIsolate();
        return result;
    }

    private CEntryPointBuiltins() {
    }
}

