/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.util.VMError;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Arrays;

public final class CEntryPointErrors {
    @Description(value="No error occurred.")
    public static final int NO_ERROR = 0;
    @Description(value="An unspecified error occurred.")
    public static final int UNSPECIFIED = 1;
    @Description(value="An argument was NULL.")
    public static final int NULL_ARGUMENT = 2;
    @Description(value="The specified thread is not attached to the isolate.")
    public static final int UNATTACHED_THREAD = 4;
    @Description(value="The specified isolate is unknown.")
    public static final int UNINITIALIZED_ISOLATE = 5;
    @Description(value="Locating the image file failed.")
    public static final int LOCATE_IMAGE_FAILED = 6;
    @Description(value="Opening the located image file failed.")
    public static final int OPEN_IMAGE_FAILED = 7;
    @Description(value="Mapping the heap from the image file into memory failed.")
    public static final int MAP_HEAP_FAILED = 8;
    @Description(value="Setting the protection of the heap memory failed.")
    public static final int PROTECT_HEAP_FAILED = 9;
    @Description(value="The version of the specified isolate parameters is unsupported.")
    public static final int UNSUPPORTED_ISOLATE_PARAMETERS_VERSION = 10;
    @Description(value="Initialization of threading in the isolate failed.")
    public static final int THREADING_INITIALIZATION_FAILED = 11;
    private static final String[] DESCRIPTIONS;

    private CEntryPointErrors() {
    }

    static String getDescription(int code) {
        String result = null;
        if (code >= 0 && code < DESCRIPTIONS.length) {
            result = DESCRIPTIONS[code];
        }
        if (result == null) {
            return "(Unknown error)";
        }
        return result;
    }

    static {
        try {
            String[] array = new String[16];
            int maxValue = 0;
            for (Field field : CEntryPointErrors.class.getDeclaredFields()) {
                if (!field.getType().equals(Integer.TYPE)) continue;
                int value = field.getInt(null);
                String description = field.getDeclaredAnnotation(Description.class).value();
                if ((maxValue = Math.max(value, maxValue)) >= array.length) {
                    array = Arrays.copyOf(array, 2 * maxValue);
                }
                array[value] = description;
            }
            DESCRIPTIONS = Arrays.copyOf(array, maxValue + 1);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Description {
        public String value();
    }
}

