/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code.amd64;

import java.util.HashMap;
import java.util.Map;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64InstructionPatcher {
    private final Map<Integer, AMD64BaseAssembler.OperandDataAnnotation> operandAnnotations = new HashMap<Integer, AMD64BaseAssembler.OperandDataAnnotation>();

    public AMD64InstructionPatcher(CompilationResult compilationResult) {
        for (CompilationResult.CodeAnnotation codeAnnotation : compilationResult.getAnnotations()) {
            Assembler.CodeAnnotation assemblerAnotation;
            if (!(codeAnnotation instanceof CompilationResultBuilder.AssemblerAnnotation) || !((assemblerAnotation = ((CompilationResultBuilder.AssemblerAnnotation)codeAnnotation).assemblerCodeAnnotation) instanceof AMD64BaseAssembler.OperandDataAnnotation)) continue;
            AMD64BaseAssembler.OperandDataAnnotation operandAnnotation = (AMD64BaseAssembler.OperandDataAnnotation)assemblerAnotation;
            this.operandAnnotations.put(operandAnnotation.instructionPosition, operandAnnotation);
        }
    }

    public PatchData findPatchData(int codePos, int relative) {
        AMD64BaseAssembler.OperandDataAnnotation operandData = this.operandAnnotations.get(codePos);
        assert (operandData.instructionPosition == codePos);
        int offset = relative - (operandData.nextInstructionPosition - operandData.instructionPosition);
        return new PatchData(operandData.operandPosition, operandData.operandSize, operandData.nextInstructionPosition, offset);
    }

    public static final class PatchData {
        public final int operandPosition;
        public final int operandSize;
        public final int nextInstructionPosition;
        public final int value;

        private PatchData(int position, int size, int nextInstructionPosition, int value) {
            this.operandPosition = position;
            this.operandSize = size;
            this.nextInstructionPosition = nextInstructionPosition;
            this.value = value;
        }

        public void apply(byte[] code) {
            int curValue = this.value;
            for (int i = 0; i < this.operandSize; ++i) {
                assert (code[this.operandPosition + i] == 0);
                code[this.operandPosition + i] = (byte)(curValue & 0xFF);
                curValue >>>= 8;
            }
            assert (curValue == 0);
        }
    }
}

