/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.nodes.FarReturnLoweredNode;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class FarReturnNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<FarReturnNode> TYPE = NodeClass.create(FarReturnNode.class);
    @Node.Input
    protected ValueNode result;
    @Node.Input
    protected ValueNode sp;
    @Node.Input
    protected ValueNode ip;

    public FarReturnNode(ValueNode result, ValueNode sp, ValueNode ip) {
        super(TYPE, StampFactory.forVoid());
        this.result = result;
        this.sp = sp;
        this.ip = ip;
    }

    public void lower(LoweringTool tool) {
        FixedNode originalNext = this.next();
        this.replaceFirstSuccessor((Node)originalNext, null);
        GraphUtil.killCFG((FixedNode)originalNext);
        this.replaceAtPredecessor(this.graph().add((Node)new FarReturnLoweredNode(this.result, this.sp, this.ip)));
        this.safeDelete();
    }
}

