/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class LoadVMThreadLocalNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<LoadVMThreadLocalNode> TYPE = NodeClass.create(LoadVMThreadLocalNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;
    protected final HeapAccess.BarrierType barrierType;
    @Node.Input
    protected ValueNode holder;

    public LoadVMThreadLocalNode(MetaAccessProvider metaAccess, VMThreadLocalInfo threadLocalInfo, ValueNode holder, HeapAccess.BarrierType barrierType) {
        super(TYPE, (Stamp)(threadLocalInfo.isObject ? StampFactory.object((TypeReference)TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)metaAccess.lookupJavaType(threadLocalInfo.valueClass))) : StampFactory.forKind((JavaKind)threadLocalInfo.storageKind)));
        this.threadLocalInfo = threadLocalInfo;
        this.barrierType = barrierType;
        this.holder = holder;
    }

    public void lower(LoweringTool tool) {
        assert (this.threadLocalInfo.offset >= 0L);
        ConstantNode offset = ConstantNode.forLong((long)this.threadLocalInfo.offset, (StructuredGraph)this.holder.graph());
        AddressNode address = (AddressNode)this.graph().unique((Node)new OffsetAddressNode(this.holder, (ValueNode)offset));
        JavaReadNode read = (JavaReadNode)this.graph().add((Node)new JavaReadNode(this.threadLocalInfo.storageKind, address, this.threadLocalInfo.locationIdentity, this.barrierType, true));
        this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)read);
        tool.getLowerer().lower((Node)read, tool);
    }
}

