/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import java.lang.annotation.Annotation;
import java.util.Objects;

public final class AnnotationsEncoding {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    public static Annotation[] getAnnotations(Object annotationsEncoding) {
        if (annotationsEncoding == null) {
            return EMPTY_ANNOTATION_ARRAY;
        }
        if (annotationsEncoding instanceof Annotation[]) {
            return (Annotation[])((Annotation[])annotationsEncoding).clone();
        }
        return new Annotation[]{(Annotation)annotationsEncoding};
    }

    public static <T extends Annotation> T getAnnotation(Object annotationsEncoding, Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        if (annotationsEncoding instanceof Annotation[]) {
            for (Annotation annotation : (Annotation[])annotationsEncoding) {
                if (!annotationClass.isInstance(annotation)) continue;
                return (T)annotation;
            }
        } else if (annotationClass.isInstance(annotationsEncoding)) {
            return (T)((Annotation)annotationsEncoding);
        }
        return null;
    }
}

