/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.SubstrateOperatingSystemMXBean;
import com.oracle.svm.core.jdk.SubstrateRuntimeMXBean;
import com.oracle.svm.core.jdk.SubstrateThreadMXBean;
import com.oracle.svm.core.util.UserError;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
final class ManagementFactoryFeature
implements Feature {
    ManagementFactoryFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(ManagementFactoryFeature::replace);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateRuntimeMXBean.class, (Object)new SubstrateRuntimeMXBean());
        ImageSingletons.add(SubstrateThreadMXBean.class, (Object)new SubstrateThreadMXBean());
        ImageSingletons.add(SubstrateOperatingSystemMXBean.class, (Object)new SubstrateOperatingSystemMXBean());
    }

    private static Object replace(Object source) {
        if (source instanceof ThreadMXBean) {
            return ImageSingletons.lookup(SubstrateThreadMXBean.class);
        }
        if (source instanceof RuntimeMXBean) {
            return ImageSingletons.lookup(SubstrateRuntimeMXBean.class);
        }
        if (source instanceof MemoryMXBean) {
            return Heap.getHeap().getMemoryMXBean();
        }
        if (source instanceof GarbageCollectorMXBean) {
            if (source.getClass().getName().equals("sun.management.GarbageCollectorImpl")) {
                if (((GarbageCollectorMXBean)source).getMemoryPoolNames().length == 2) {
                    GarbageCollectorMXBean incrementalBean = Heap.getHeap().getGC().getGarbageCollectorMXBeanList().get(0);
                    assert (incrementalBean.getName().equals("young generation scavenger"));
                    return incrementalBean;
                }
                if (((GarbageCollectorMXBean)source).getMemoryPoolNames().length == 3) {
                    GarbageCollectorMXBean completeBean = Heap.getHeap().getGC().getGarbageCollectorMXBeanList().get(1);
                    assert (completeBean.getName().equals("complete scavenger"));
                    return completeBean;
                }
                throw UserError.abort("Found " + source + " in image heap. Don't know to which Substrate VM GC bean to map.");
            }
            return source;
        }
        return source;
    }
}

