/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.FilesSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Files.class)
final class Target_java_nio_file_Files {
    Target_java_nio_file_Files() {
    }

    @Substitute
    private static String probeContentType(Path path) throws IOException {
        FilesSupport fs = (FilesSupport)ImageSingletons.lookup(FilesSupport.class);
        for (FileTypeDetector detector : fs.installedDetectors) {
            String result = detector.probeContentType(path);
            if (result == null) continue;
            return result;
        }
        return fs.defaultFileTypeDetector.probeContentType(path);
    }
}

