/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk8.zipfile;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk8.zipfile.ZipConstants;
import com.oracle.svm.core.jdk8.zipfile.ZipUtils;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Substitute
@TargetClass(value=java.util.zip.ZipEntry.class, onlyWith={JDK8OrEarlier.class})
public final class ZipEntry
implements ZipConstants,
Cloneable {
    @Substitute
    String name;
    @Substitute
    long xdostime = -1L;
    @Substitute
    FileTime mtime;
    @Substitute
    FileTime atime;
    @Substitute
    FileTime ctime;
    @Substitute
    long crc = -1L;
    @Substitute
    long size = -1L;
    @Substitute
    long csize = -1L;
    @Substitute
    int method = -1;
    @Substitute
    int flag = 0;
    @Substitute
    byte[] extra;
    @Substitute
    String comment;
    @Substitute
    public static final int STORED = 0;
    @Substitute
    public static final int DEFLATED = 8;
    @Substitute
    static final long DOSTIME_BEFORE_1980 = 0x210000L;
    @Substitute
    private static final long UPPER_DOSTIME_BOUND = 4036608000000L;

    @Substitute
    public ZipEntry(String name) {
        Objects.requireNonNull(name, "name");
        if (name.length() > 65535) {
            throw new IllegalArgumentException("entry name too long");
        }
        this.name = name;
    }

    @Substitute
    public ZipEntry(ZipEntry e) {
        Objects.requireNonNull(e, "entry");
        this.name = e.name;
        this.xdostime = e.xdostime;
        this.mtime = e.mtime;
        this.atime = e.atime;
        this.ctime = e.ctime;
        this.crc = e.crc;
        this.size = e.size;
        this.csize = e.csize;
        this.method = e.method;
        this.flag = e.flag;
        this.extra = e.extra;
        this.comment = e.comment;
    }

    @Substitute
    ZipEntry() {
    }

    @Substitute
    public String getName() {
        return this.name;
    }

    @Substitute
    public void setTime(long time) {
        this.xdostime = ZipUtils.javaToExtendedDosTime(time);
        this.mtime = this.xdostime != 0x210000L && time <= 4036608000000L ? null : FileTime.from(time, TimeUnit.MILLISECONDS);
    }

    @Substitute
    public long getTime() {
        if (this.mtime != null) {
            return this.mtime.toMillis();
        }
        return this.xdostime != -1L ? ZipUtils.extendedDosToJavaTime(this.xdostime) : -1L;
    }

    public void setTimeLocal(LocalDateTime time) {
        int year = time.getYear() - 1980;
        this.xdostime = year < 0 ? 0x210000L : ((long)(year << 25 | time.getMonthValue() << 21 | time.getDayOfMonth() << 16 | time.getHour() << 11 | time.getMinute() << 5 | time.getSecond() >> 1) & 0xFFFFFFFFL) + ((long)((time.getSecond() & 1) * 1000 + time.getNano() / 1000000) << 32);
        this.mtime = this.xdostime != 0x210000L && year <= 127 ? null : FileTime.from(ZonedDateTime.of(time, ZoneId.systemDefault()).toInstant());
    }

    public LocalDateTime getTimeLocal() {
        if (this.mtime != null) {
            return LocalDateTime.ofInstant(this.mtime.toInstant(), ZoneId.systemDefault());
        }
        int ms = (int)(this.xdostime >> 32);
        return LocalDateTime.of((int)((this.xdostime >> 25 & 0x7FL) + 1980L), (int)(this.xdostime >> 21 & 0xFL), (int)(this.xdostime >> 16 & 0x1FL), (int)(this.xdostime >> 11 & 0x1FL), (int)(this.xdostime >> 5 & 0x3FL), (int)(this.xdostime << 1 & 0x3EL) + ms / 1000, ms % 1000 * 1000000);
    }

    @Substitute
    public ZipEntry setLastModifiedTime(FileTime time) {
        this.mtime = Objects.requireNonNull(time, "lastModifiedTime");
        this.xdostime = ZipUtils.javaToExtendedDosTime(time.to(TimeUnit.MILLISECONDS));
        return this;
    }

    @Substitute
    public FileTime getLastModifiedTime() {
        if (this.mtime != null) {
            return this.mtime;
        }
        if (this.xdostime == -1L) {
            return null;
        }
        return FileTime.from(this.getTime(), TimeUnit.MILLISECONDS);
    }

    @Substitute
    public ZipEntry setLastAccessTime(FileTime time) {
        this.atime = Objects.requireNonNull(time, "lastAccessTime");
        return this;
    }

    @Substitute
    public FileTime getLastAccessTime() {
        return this.atime;
    }

    @Substitute
    public ZipEntry setCreationTime(FileTime time) {
        this.ctime = Objects.requireNonNull(time, "creationTime");
        return this;
    }

    @Substitute
    public FileTime getCreationTime() {
        return this.ctime;
    }

    @Substitute
    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = size;
    }

    @Substitute
    public long getSize() {
        return this.size;
    }

    @Substitute
    public long getCompressedSize() {
        return this.csize;
    }

    @Substitute
    public void setCompressedSize(long csize) {
        this.csize = csize;
    }

    @Substitute
    public void setCrc(long crc) {
        if (crc < 0L || crc > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = crc;
    }

    @Substitute
    public long getCrc() {
        return this.crc;
    }

    @Substitute
    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = method;
    }

    @Substitute
    public int getMethod() {
        return this.method;
    }

    @Substitute
    public void setExtra(byte[] extra) {
        this.setExtra0(extra, false);
    }

    @Substitute
    void setExtra0(byte[] extra, boolean doZIP64) {
        if (extra != null) {
            if (extra.length > 65535) {
                throw new IllegalArgumentException("invalid extra field length");
            }
            int off = 0;
            int len = extra.length;
            while (off + 4 < len) {
                int sz;
                int tag = ZipUtils.get16(extra, off);
                if ((off += 4) + (sz = ZipUtils.get16(extra, off + 2)) > len) break;
                switch (tag) {
                    case 1: {
                        if (!doZIP64 || sz < 16) break;
                        this.size = ZipUtils.get64(extra, off);
                        this.csize = ZipUtils.get64(extra, off + 8);
                        break;
                    }
                    case 10: {
                        int pos;
                        if (sz < 32 || ZipUtils.get16(extra, pos = off + 4) != 1 || ZipUtils.get16(extra, pos + 2) != 24) break;
                        long wtime = ZipUtils.get64(extra, pos + 4);
                        if (wtime != Long.MIN_VALUE) {
                            this.mtime = ZipUtils.winTimeToFileTime(wtime);
                        }
                        if ((wtime = ZipUtils.get64(extra, pos + 12)) != Long.MIN_VALUE) {
                            this.atime = ZipUtils.winTimeToFileTime(wtime);
                        }
                        if ((wtime = ZipUtils.get64(extra, pos + 20)) == Long.MIN_VALUE) break;
                        this.ctime = ZipUtils.winTimeToFileTime(wtime);
                        break;
                    }
                    case 21589: {
                        int flag = Byte.toUnsignedInt(extra[off]);
                        int sz0 = 1;
                        if ((flag & 1) != 0 && sz0 + 4 <= sz) {
                            this.mtime = ZipUtils.unixTimeToFileTime(ZipUtils.get32S(extra, off + sz0));
                            sz0 += 4;
                        }
                        if ((flag & 2) != 0 && sz0 + 4 <= sz) {
                            this.atime = ZipUtils.unixTimeToFileTime(ZipUtils.get32S(extra, off + sz0));
                            sz0 += 4;
                        }
                        if ((flag & 4) == 0 || sz0 + 4 > sz) break;
                        this.ctime = ZipUtils.unixTimeToFileTime(ZipUtils.get32S(extra, off + sz0));
                        sz0 += 4;
                        break;
                    }
                }
                off += sz;
            }
        }
        this.extra = extra;
    }

    @Substitute
    public byte[] getExtra() {
        return this.extra;
    }

    @Substitute
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Substitute
    public String getComment() {
        return this.comment;
    }

    @Substitute
    public boolean isDirectory() {
        return this.name.endsWith("/");
    }

    @Substitute
    public String toString() {
        return this.getName();
    }

    @Substitute
    public int hashCode() {
        return this.name.hashCode();
    }

    @Substitute
    public Object clone() {
        try {
            ZipEntry e = (ZipEntry)super.clone();
            e.extra = this.extra == null ? null : (byte[])this.extra.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

