/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

class SubstrateSegfaultHandler {
    private static volatile boolean dispatchInProgress = false;
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(SubstrateSegfaultHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    SubstrateSegfaultHandler() {
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault signal handler.")
    @Uninterruptible(reason="Must be uninterruptible until it gets immune to safepoints", calleeMustBe=false)
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (dispatchInProgress) {
            Log.log().newline().string("[ [ SubstrateSegfaultHandler already handling signal ").signed(signalNumber).string(" ] ]").newline();
            return;
        }
        dispatchInProgress = true;
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        Log log = Log.log();
        log.autoflush(true);
        log.string("[ [ SubstrateSegfaultHandler caught signal ").signed(signalNumber).string(" ] ]").newline();
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        long spValue = gregs.read(Signal.GregEnum.REG_RSP.getCValue());
        long ipValue = gregs.read(Signal.GregEnum.REG_RIP.getCValue());
        log.newline().string("General Purpose Register Set Values: ").newline();
        log.indent(true);
        log.string("RAX ").zhex(gregs.read(Signal.GregEnum.REG_RAX.getCValue())).newline();
        log.string("RBX ").zhex(gregs.read(Signal.GregEnum.REG_RBX.getCValue())).newline();
        log.string("RCX ").zhex(gregs.read(Signal.GregEnum.REG_RCX.getCValue())).newline();
        log.string("RDX ").zhex(gregs.read(Signal.GregEnum.REG_RDX.getCValue())).newline();
        log.string("RBP ").zhex(gregs.read(Signal.GregEnum.REG_RBP.getCValue())).newline();
        log.string("RSI ").zhex(gregs.read(Signal.GregEnum.REG_RSI.getCValue())).newline();
        log.string("RDI ").zhex(gregs.read(Signal.GregEnum.REG_RDI.getCValue())).newline();
        log.string("RSP ").zhex(spValue).newline();
        log.string("R8  ").zhex(gregs.read(Signal.GregEnum.REG_R8.getCValue())).newline();
        log.string("R9  ").zhex(gregs.read(Signal.GregEnum.REG_R9.getCValue())).newline();
        log.string("R10 ").zhex(gregs.read(Signal.GregEnum.REG_R10.getCValue())).newline();
        log.string("R11 ").zhex(gregs.read(Signal.GregEnum.REG_R11.getCValue())).newline();
        log.string("R12 ").zhex(gregs.read(Signal.GregEnum.REG_R12.getCValue())).newline();
        log.string("R13 ").zhex(gregs.read(Signal.GregEnum.REG_R13.getCValue())).newline();
        log.string("R14 ").zhex(gregs.read(Signal.GregEnum.REG_R14.getCValue())).newline();
        log.string("R15 ").zhex(gregs.read(Signal.GregEnum.REG_R15.getCValue())).newline();
        log.string("EFL ").zhex(gregs.read(Signal.GregEnum.REG_EFL.getCValue())).newline();
        log.string("RIP ").zhex(ipValue).newline();
        log.indent(false);
        SubstrateUtil.printDiagnostics(log, (Pointer)WordFactory.pointer((long)spValue), (CodePointer)WordFactory.pointer((long)ipValue));
        log.string("Use runtime option -R:-InstallSegfaultHandler if you don't want to use SubstrateSegfaultHandler.").newline();
        log.newline().string("Bye bye ...").newline().newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    static void install() {
        if (Options.InstallSegfaultHandler.getValue().booleanValue()) {
            int structSigActionSize = SizeOf.get(Signal.sigaction.class);
            Signal.sigaction structSigAction = (Signal.sigaction)StackValue.get((int)structSigActionSize);
            LibC.memset(structSigAction, WordFactory.signed((int)0), WordFactory.unsigned((int)structSigActionSize));
            structSigAction.sa_flags(Signal.SA_SIGINFO());
            structSigAction.sa_sigaction((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
            Signal.sigaction(Signal.SignalEnum.SIGSEGV, structSigAction, (Signal.sigaction)WordFactory.nullPointer());
        }
    }

    public static class Options {
        @Option(help={"Install segfault handler that prints register contents and full Java stacktrace"})
        static final RuntimeOptionKey<Boolean> InstallSegfaultHandler = new RuntimeOptionKey<Boolean>(true);
    }
}

