/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.VmRuntimeOS;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Ioctl;
import com.oracle.svm.core.posix.headers.Poll;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Unistd;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class Target_os {
    private Target_os() {
    }

    static int timeout(int fd, long timeoutArg) {
        int res;
        int timeout = (int)timeoutArg;
        long prevtime = System.currentTimeMillis();
        Poll.pollfd pfd = (Poll.pollfd)StackValue.get(Poll.pollfd.class);
        while (true) {
            pfd.set_fd(fd);
            pfd.set_events(Poll.POLLIN() | Poll.POLLERR());
            boolean limitedTimeout = false;
            res = Poll.poll(pfd, 1, timeout);
            if (res != VmRuntimeOS.OSReturn.OS_ERR() || Errno.errno() != Errno.EINTR()) break;
            if (timeout < 0) continue;
            long newtime = System.currentTimeMillis();
            if ((timeout = (int)((long)timeout - (newtime - prevtime))) <= 0) {
                return VmRuntimeOS.OSReturn.OS_OK();
            }
            prevtime = newtime;
        }
        return res;
    }

    static long restartable_read(int fd, CCharPointer buf, int nBytes) {
        long res = 0L;
        while ((res = Unistd.read(fd, (PointerBase)buf, WordFactory.unsigned((int)nBytes)).rawValue()) == (long)VmRuntimeOS.OSReturn.OS_ERR() || Errno.errno() == Errno.EINTR()) {
        }
        return res;
    }

    static int socket_available(int fd, CIntPointer pbytes) {
        int ret;
        if (fd < 0) {
            return VmRuntimeOS.OSReturn.OS_OK();
        }
        while ((ret = Ioctl.ioctl(fd, Ioctl.FIONREAD(), (PointerBase)pbytes)) == VmRuntimeOS.OSReturn.OS_ERR() || Errno.errno() == Errno.EINTR()) {
        }
        return ret == VmRuntimeOS.OSReturn.OS_ERR() ? 0 : 1;
    }

    static int send(int fd, CCharPointer buf, long nBytes, int flags) {
        int _result;
        while ((_result = (int)Socket.send(fd, (PointerBase)buf, WordFactory.unsigned((long)nBytes), flags).rawValue()) == VmRuntimeOS.OSReturn.OS_ERR() || Errno.errno() == Errno.EINTR()) {
        }
        return _result;
    }

    static int sendto(int fd, CCharPointer buf, int n, int flags, Socket.sockaddr addr, int addr_len) {
        int _result;
        while ((_result = (int)Socket.sendto(fd, (PointerBase)buf, WordFactory.unsigned((int)n), flags, addr, addr_len).rawValue()) == VmRuntimeOS.OSReturn.OS_ERR() || Errno.errno() == Errno.EINTR()) {
        }
        return _result;
    }

    static int recvfrom(int fd, CCharPointer buf, int n, int flags, Socket.sockaddr addr, CIntPointer addr_len) {
        int _result;
        while ((_result = (int)Socket.recvfrom(fd, (PointerBase)buf, WordFactory.unsigned((int)n), flags, addr, addr_len).rawValue()) == VmRuntimeOS.OSReturn.OS_ERR() || Errno.errno() == Errno.EINTR()) {
        }
        return _result;
    }

    static int socket_close(int fd) {
        return Unistd.close(fd);
    }

    static int get_sock_name(int fd, Socket.sockaddr him, CIntPointer len_Pointer) {
        return Socket.getsockname(fd, him, len_Pointer);
    }

    static int get_host_name(CCharPointer name, int namelen) {
        return Unistd.gethostname(name, WordFactory.unsigned((int)namelen));
    }

    static int listen(int fd, int count) {
        if (fd < 0) {
            return VmRuntimeOS.OSReturn.OS_ERR();
        }
        return Socket.listen(fd, count);
    }
}

