/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.nativeimage.Feature;

public final class DeoptimizationFeature
implements Feature {
    private static final Method deoptStubMethod;
    private static final Method deoptimizeMethod;

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        config.registerAsCompiled(deoptStubMethod);
        config.registerAsCompiled(deoptimizeMethod);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        HostedMetaAccess metaAccess = config.getMetaAccess();
        DeoptimizationSupport.setDeoptStubPointer(MethodPointer.factory(metaAccess.lookupJavaMethod(deoptStubMethod)));
    }

    static {
        try {
            deoptStubMethod = Deoptimizer.class.getMethod("deoptStub", DeoptimizedFrame.class);
            deoptimizeMethod = SnippetRuntime.class.getDeclaredMethod("deoptimize", Long.TYPE, SpeculationLog.SpeculationReason.class);
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

