/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.graal.pointsto.infrastructure.WrappedElement;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.BuiltinDirectives;
import com.oracle.svm.hosted.c.CAnnotationProcessor;
import com.oracle.svm.hosted.c.CAnnotationProcessorCache;
import com.oracle.svm.hosted.c.CInterfaceError;
import com.oracle.svm.hosted.c.NativeCodeContext;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.impl.CConstantValueSupport;
import org.graalvm.nativeimage.impl.SizeOfSupport;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class NativeLibraries {
    private final MetaAccessProvider metaAccess;
    private final SnippetReflectionProvider snippetReflection;
    private final TargetDescription target;
    private final Map<Object, ElementInfo> elementToInfo;
    private final Map<Class<? extends CContext.Directives>, NativeCodeContext> compilationUnitToContext;
    private final ResolvedJavaType wordBaseType;
    private final ResolvedJavaType signedType;
    private final ResolvedJavaType unsignedType;
    private final ResolvedJavaType pointerBaseType;
    private final ResolvedJavaType stringType;
    private final ResolvedJavaType byteArrayType;
    private final ResolvedJavaType enumType;
    private final ResolvedJavaType locationIdentityType;
    private final List<String> libraries;
    private final List<String> libraryPaths;
    private final List<CInterfaceError> errors;
    private final ConstantReflectionProvider constantReflection;
    private final CAnnotationProcessorCache cache;

    public NativeLibraries(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, TargetDescription target) {
        this.metaAccess = metaAccess;
        this.constantReflection = constantReflection;
        this.snippetReflection = snippetReflection;
        this.target = target;
        this.elementToInfo = new HashMap<Object, ElementInfo>();
        this.errors = new ArrayList<CInterfaceError>();
        this.compilationUnitToContext = new HashMap<Class<? extends CContext.Directives>, NativeCodeContext>();
        this.wordBaseType = metaAccess.lookupJavaType(WordBase.class);
        this.signedType = metaAccess.lookupJavaType(SignedWord.class);
        this.unsignedType = metaAccess.lookupJavaType(UnsignedWord.class);
        this.pointerBaseType = metaAccess.lookupJavaType(PointerBase.class);
        this.stringType = metaAccess.lookupJavaType(String.class);
        this.byteArrayType = metaAccess.lookupJavaType(byte[].class);
        this.enumType = metaAccess.lookupJavaType(Enum.class);
        this.locationIdentityType = metaAccess.lookupJavaType(LocationIdentity.class);
        this.libraries = new ArrayList<String>();
        this.libraryPaths = new ArrayList<String>();
        ImageSingletons.add(SizeOfSupport.class, (Object)new SizeOfSupportImpl(this));
        ImageSingletons.add(CConstantValueSupport.class, (Object)new CConstantValueSupportImpl(this));
        this.cache = new CAnnotationProcessorCache();
    }

    public MetaAccessProvider getMetaAccess() {
        return this.metaAccess;
    }

    public SnippetReflectionProvider getSnippetReflection() {
        return this.snippetReflection;
    }

    public TargetDescription getTarget() {
        return this.target;
    }

    public void addError(String msg, Object ... context) {
        this.getErrors().add(new CInterfaceError(msg, context));
    }

    public List<CInterfaceError> getErrors() {
        return this.errors;
    }

    public void reportErrors() {
        if (this.errors.size() > 0) {
            throw UserError.abort(this.errors.stream().map(CInterfaceError::getMessage).collect(Collectors.toList()));
        }
    }

    public void loadJavaMethod(ResolvedJavaMethod method) {
        Class<? extends CContext.Directives> directives = this.getDirectives(method);
        NativeCodeContext context = this.makeContext(directives);
        if (context.isInConfiguration()) {
            if (method.getAnnotation(CConstant.class) != null) {
                context.appendConstantAccessor(method);
            } else {
                this.addError("Method is not annotated with supported C interface annotation", method);
            }
        }
    }

    public void loadJavaType(ResolvedJavaType type) {
        NativeCodeContext context = this.makeContext(this.getDirectives(type));
        if (context.isInConfiguration()) {
            if (type.getAnnotation(CStruct.class) != null) {
                context.appendStructType(type);
            } else if (type.getAnnotation(RawStructure.class) != null) {
                context.appendRawStructType(type);
            } else if (type.getAnnotation(CPointerTo.class) != null) {
                context.appendPointerToType(type);
            } else if (type.getAnnotation(CEnum.class) != null) {
                context.appendEnumType(type);
            } else {
                this.addError("Type is not annotated with supported C interface annotation", type);
            }
        }
    }

    public void addLibrary(String library) {
        this.libraries.add(library);
    }

    public Collection<String> getLibraries() {
        return this.libraries;
    }

    public List<String> getLibraryPaths() {
        return this.libraryPaths;
    }

    private NativeCodeContext makeContext(Class<? extends CContext.Directives> compilationUnit) {
        NativeCodeContext result = this.compilationUnitToContext.get(compilationUnit);
        if (result == null) {
            try {
                Constructor<? extends CContext.Directives> constructor = compilationUnit.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                CContext.Directives unit = constructor.newInstance(new Object[0]);
                result = new NativeCodeContext(unit);
                this.compilationUnitToContext.put(compilationUnit, result);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                throw UserError.abort("can't construct compilation unit " + compilationUnit.getCanonicalName() + ": " + e);
            }
        }
        return result;
    }

    private static Object unwrap(Object e) {
        Object element = e;
        assert (element instanceof ResolvedJavaType || element instanceof ResolvedJavaMethod);
        while (element instanceof WrappedElement) {
            element = ((WrappedElement)element).getWrapped();
        }
        assert (element instanceof ResolvedJavaType || element instanceof ResolvedJavaMethod);
        return element;
    }

    public void registerElementInfo(Object e, ElementInfo elementInfo) {
        Object element = NativeLibraries.unwrap(e);
        assert (!this.elementToInfo.containsKey(element));
        this.elementToInfo.put(element, elementInfo);
    }

    public ElementInfo findElementInfo(Object e) {
        Object element = NativeLibraries.unwrap(e);
        ElementInfo result = this.elementToInfo.get(element);
        if (result == null && element instanceof ResolvedJavaType && ((ResolvedJavaType)element).getInterfaces().length == 1) {
            result = this.findElementInfo(((ResolvedJavaType)element).getInterfaces()[0]);
        }
        return result;
    }

    private static Class<? extends CContext.Directives> getDirectives(CContext useUnit) {
        return useUnit.value();
    }

    private Class<? extends CContext.Directives> getDirectives(ResolvedJavaMethod method) {
        CContext useUnit = (CContext)method.getAnnotation(CContext.class);
        if (useUnit != null) {
            return NativeLibraries.getDirectives(useUnit);
        }
        return this.getDirectives(method.getDeclaringClass());
    }

    private Class<? extends CContext.Directives> getDirectives(ResolvedJavaType type) {
        CContext useUnit = (CContext)type.getAnnotation(CContext.class);
        if (useUnit != null) {
            return NativeLibraries.getDirectives(useUnit);
        }
        if (type.getEnclosingType() != null) {
            return this.getDirectives(type.getEnclosingType());
        }
        return BuiltinDirectives.class;
    }

    public void finish(Path tempDirectory) {
        this.libraryPaths.addAll(OptionUtils.flatten(",", SubstrateOptions.CLibraryPath.getValue()));
        for (NativeCodeContext context : this.compilationUnitToContext.values()) {
            if (!context.isInConfiguration()) continue;
            this.libraries.addAll(context.getDirectives().getLibraries());
            this.libraryPaths.addAll(context.getDirectives().getLibraryPaths());
            new CAnnotationProcessor(this, context, tempDirectory).process(this.cache);
        }
    }

    public boolean isWordBase(ResolvedJavaType type) {
        return this.wordBaseType.isAssignableFrom(type);
    }

    public boolean isPointerBase(ResolvedJavaType type) {
        return this.pointerBaseType.isAssignableFrom(type);
    }

    public boolean isSigned(ResolvedJavaType type) {
        return this.signedType.equals(type);
    }

    public boolean isUnsigned(ResolvedJavaType type) {
        return this.unsignedType.equals(type);
    }

    public boolean isString(ResolvedJavaType type) {
        return this.stringType.isAssignableFrom(type);
    }

    public boolean isByteArray(ResolvedJavaType type) {
        return this.byteArrayType.isAssignableFrom(type);
    }

    public boolean isEnum(ResolvedJavaType type) {
        return this.enumType.isAssignableFrom(type);
    }

    public ResolvedJavaType getPointerBaseType() {
        return this.pointerBaseType;
    }

    public ResolvedJavaType getLocationIdentityType() {
        return this.locationIdentityType;
    }

    public ConstantReflectionProvider getConstantReflection() {
        return this.constantReflection;
    }

    static final class CConstantValueSupportImpl
    implements CConstantValueSupport {
        private final NativeLibraries nativeLibraries;

        CConstantValueSupportImpl(NativeLibraries nativeLibraries) {
            this.nativeLibraries = nativeLibraries;
        }

        public <T> T getCConstantValue(Class<?> declaringClass, String methodName, Class<T> returnType) {
            ResolvedJavaMethod method;
            try {
                method = this.nativeLibraries.metaAccess.lookupJavaMethod((Executable)declaringClass.getMethod(methodName, new Class[0]));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw VMError.shouldNotReachHere("Method not found: " + declaringClass.getName() + "." + methodName);
            }
            if (method.getAnnotation(CConstant.class) == null) {
                throw VMError.shouldNotReachHere("Method " + declaringClass.getName() + "." + methodName + " is not annotated with @" + CConstant.class.getSimpleName());
            }
            ConstantInfo constantInfo = (ConstantInfo)this.nativeLibraries.findElementInfo(method);
            Object value = constantInfo.getValueInfo().getProperty();
            switch (constantInfo.getKind()) {
                case INTEGER: 
                case POINTER: {
                    Long longValue = (Long)value;
                    if (returnType == Boolean.class) {
                        return returnType.cast(longValue != 0L);
                    }
                    if (returnType == Integer.class) {
                        return returnType.cast((int)longValue.longValue());
                    }
                    if (returnType != Long.class) break;
                    return returnType.cast(value);
                }
                case FLOAT: {
                    if (returnType != Double.class) break;
                    return returnType.cast(value);
                }
                case STRING: {
                    if (returnType != String.class) break;
                    return returnType.cast(value);
                }
                case BYTEARRAY: {
                    if (returnType != byte[].class) break;
                    return returnType.cast(value);
                }
            }
            throw VMError.shouldNotReachHere("Unexpected returnType: " + returnType.getName());
        }
    }

    static final class SizeOfSupportImpl
    implements SizeOfSupport {
        private final NativeLibraries nativeLibraries;

        SizeOfSupportImpl(NativeLibraries nativeLibraries) {
            this.nativeLibraries = nativeLibraries;
        }

        public int sizeof(Class<? extends PointerBase> clazz) {
            ResolvedJavaType type = this.nativeLibraries.metaAccess.lookupJavaType(clazz);
            ElementInfo typeInfo = this.nativeLibraries.findElementInfo(type);
            if (typeInfo instanceof StructInfo && ((StructInfo)typeInfo).isIncomplete()) {
                throw UserError.abort("Class parameter " + type.toJavaName(true) + " of call to " + SizeOf.class.getSimpleName() + " is an incomplete structure, so no size is available");
            }
            if (typeInfo instanceof SizableInfo) {
                return ((SizableInfo)typeInfo).getSizeInfo().getProperty();
            }
            throw UserError.abort("Class parameter " + type.toJavaName(true) + " of call to " + SizeOf.class.getSimpleName() + " is not an annotated C interface type");
        }
    }
}

