/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.cenum;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.hosted.cenum.CEnumCallWrapperMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;

public class CEnumCallWrapperSubstitutionProcessor
extends SubstitutionProcessor {
    private final Map<ResolvedJavaMethod, CEnumCallWrapperMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, CEnumCallWrapperMethod>();

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        if (method.getAnnotation(CEnumLookup.class) != null || method.getAnnotation(CEnumValue.class) != null) {
            return this.callWrappers.computeIfAbsent(method, CEnumCallWrapperMethod::new);
        }
        return method;
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof CEnumCallWrapperMethod) {
            return ((CEnumCallWrapperMethod)method).getOriginal();
        }
        return method;
    }
}

