/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.hosted.image.AbstractBootImage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CCLinkerInvocation
implements LinkerInvocation {
    protected final List<String> additionalPreOptions = new ArrayList<String>();
    protected String compilerCommand = "cc";
    protected final List<String> inputFilenames = new ArrayList<String>();
    protected final List<String> rpaths = new ArrayList<String>();
    protected final List<String> libpaths = new ArrayList<String>();
    protected final List<String> libs = new ArrayList<String>();
    protected final Map<String, String> symbolAliases = new HashMap<String, String>();
    protected Path outputFile;
    protected AbstractBootImage.NativeImageKind outputKind;

    @Override
    public List<String> getInputFiles() {
        return Collections.unmodifiableList(this.inputFilenames);
    }

    @Override
    public void addInputFile(String filename) {
        this.inputFilenames.add(filename);
    }

    @Override
    public void addInputFile(int index, String filename) {
        this.inputFilenames.add(index, filename);
    }

    public AbstractBootImage.NativeImageKind getOutputKind() {
        return this.outputKind;
    }

    public void setOutputKind(AbstractBootImage.NativeImageKind k) {
        this.outputKind = k;
    }

    @Override
    public Map<String, String> getSymbolAliases() {
        return Collections.unmodifiableMap(this.symbolAliases);
    }

    @Override
    public void addSymbolAlias(String alias, String definition) {
        this.symbolAliases.put(alias, definition);
    }

    @Override
    public List<String> getLibPaths() {
        return Collections.unmodifiableList(this.libpaths);
    }

    @Override
    public void addLibPath(String libPath) {
        this.addLibPath(this.libpaths.size(), libPath);
    }

    @Override
    public void addLibPath(int index, String libPath) {
        if (!libPath.isEmpty()) {
            this.libpaths.add(index, libPath);
        }
    }

    @Override
    public List<String> getRPaths() {
        return Collections.unmodifiableList(this.rpaths);
    }

    @Override
    public void addRPath(String rPath) {
        this.addRPath(this.rpaths.size(), rPath);
    }

    @Override
    public void addRPath(int index, String rPath) {
        if (!rPath.isEmpty()) {
            this.rpaths.add(rPath);
        }
    }

    @Override
    public Path getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void setOutputFile(Path out) {
        this.outputFile = out;
    }

    @Override
    public List<String> getLinkedLibraries() {
        return Collections.unmodifiableList(this.libs);
    }

    @Override
    public void addLinkedLibrary(String libname) {
        this.libs.add(libname);
    }

    @Override
    public void addLinkedLibrary(int index, String libname) {
        this.libs.add(index, libname);
    }

    @Override
    public String getCompilerCommand() {
        return this.compilerCommand;
    }

    @Override
    public void setCompilerCommand(String command) {
        this.compilerCommand = command;
    }

    protected abstract void addOneSymbolAliasOption(List<String> var1, Map.Entry<String, String> var2);

    protected abstract void setOutputKind(List<String> var1);

    @Override
    public List<String> getCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.compilerCommand);
        cmd.add("-v");
        cmd.add("-o");
        cmd.add(this.outputFile.toString());
        for (String string : this.additionalPreOptions) {
            cmd.add(string);
        }
        this.setOutputKind(cmd);
        for (Map.Entry entry : this.symbolAliases.entrySet()) {
            this.addOneSymbolAliasOption(cmd, entry);
        }
        for (String string : this.libpaths) {
            cmd.add("-L" + string);
        }
        for (String string : this.rpaths) {
            cmd.add("-Wl,-rpath");
            cmd.add("-Wl," + string);
        }
        cmd.addAll(this.inputFilenames);
        for (String string : this.libs) {
            if (string.startsWith("-")) {
                cmd.add("-Wl," + string.replace(" ", ","));
                continue;
            }
            cmd.add("-l" + string);
        }
        return cmd;
    }

    @Override
    public void addAdditionalPreOption(String option) {
        this.additionalPreOptions.add(option);
    }
}

