/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.nodes;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.nodes.AssertTypeStateNode;
import com.oracle.svm.hosted.nodes.AssertValueNode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class AssertStampNode
extends AssertValueNode
implements Virtualizable {
    public static final NodeClass<AssertStampNode> TYPE = NodeClass.create(AssertStampNode.class);

    public static void create(ValueNode input) {
        AssertStampNode.insert(input, (AssertValueNode)input.graph().add((Node)new AssertStampNode(input.stamp(NodeView.DEFAULT))));
    }

    protected AssertStampNode(Stamp stamp) {
        super(TYPE, stamp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean alwaysHolds(boolean reportError) {
        if (!this.getInput().isConstant()) return (this.getInput() instanceof AssertStampNode || this.getInput() instanceof AssertTypeStateNode) && this.stamp(NodeView.DEFAULT).join(this.getInput().stamp(NodeView.DEFAULT)).equals(this.getInput().stamp(NodeView.DEFAULT));
        if (this.getInput().asJavaConstant().isNull()) {
            if (!StampTool.isPointerNonNull((ValueNode)this)) return true;
            if (!reportError) return (this.getInput() instanceof AssertStampNode || this.getInput() instanceof AssertTypeStateNode) && this.stamp(NodeView.DEFAULT).join(this.getInput().stamp(NodeView.DEFAULT)).equals(this.getInput().stamp(NodeView.DEFAULT));
            throw VMError.shouldNotReachHere("Null constant not compatible with stamp: " + (Object)((Object)this) + " : " + this.stamp(NodeView.DEFAULT));
        }
        if (StampTool.typeOrNull((ValueNode)this).isAssignableFrom(StampTool.typeOrNull((ValueNode)this.getInput()))) return true;
        if (!reportError) return (this.getInput() instanceof AssertStampNode || this.getInput() instanceof AssertTypeStateNode) && this.stamp(NodeView.DEFAULT).join(this.getInput().stamp(NodeView.DEFAULT)).equals(this.getInput().stamp(NodeView.DEFAULT));
        throw VMError.shouldNotReachHere("Constant object not compatible with stamp: " + (Object)((Object)this) + " : " + this.stamp(NodeView.DEFAULT) + ", " + StampTool.typeOrNull((ValueNode)this.getInput()));
    }

    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.getInput());
        if (alias instanceof VirtualObjectNode) {
            if (!StampTool.typeOrNull((ValueNode)this).isAssignableFrom(StampTool.typeOrNull((ValueNode)alias))) {
                throw VMError.shouldNotReachHere("Virtual object not compatible with stamp: " + this.stamp(NodeView.DEFAULT) + ", " + alias.stamp(NodeView.DEFAULT));
            }
            tool.replaceWith(alias);
        }
    }
}

